# Marital Status (2.8 - 1.1.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Marital Status (2.8 - 1.1.0)**

## CodeSystem: Marital Status (2.8 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/maritalStatus | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:MaritalStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.179 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.x messages in the PID segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmaritalStatus](ValueSet-hl7VSmaritalStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "maritalStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0002"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/maritalStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.179"
    }
  ],
  "version" : "1.1.0",
  "name" : "MaritalStatus",
  "title" : "Marital Status (2.8 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying a person's marital (civil/legal) status.  Used in HL7 Version 2.x messages in the PID segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "livingTogether",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#livingTogether",
      "description" : "livingTogether",
      "type" : "boolean"
    },
    {
      "code" : "married",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#married",
      "description" : "married",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Separated",
      "definition" : "Separated",
      "designation" : [
        {
          "language" : "de",
          "value" : "getrennt lebend"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B",
      "display" : "Unmarried",
      "definition" : "Unmarried",
      "designation" : [
        {
          "language" : "de",
          "value" : "ledig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Common law",
      "definition" : "Common law",
      "designation" : [
        {
          "language" : "de",
          "value" : "eheähnliche Gemeinschaft"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Divorced",
      "definition" : "Divorced",
      "designation" : [
        {
          "language" : "de",
          "value" : "geschieden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Legally Separated",
      "definition" : "Legally Separated",
      "designation" : [
        {
          "language" : "de",
          "value" : "rechtskräftig getrennt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "G",
      "display" : "Living together",
      "definition" : "Living together",
      "designation" : [
        {
          "language" : "de",
          "value" : "zusammenlebend"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Interlocutory",
      "definition" : "Interlocutory",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Married",
      "definition" : "Married",
      "designation" : [
        {
          "language" : "de",
          "value" : "verheiratet"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Annulled",
      "definition" : "Annulled",
      "designation" : [
        {
          "language" : "de",
          "value" : "annulliert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "sonstiges"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Domestic partner",
      "definition" : "Domestic partner",
      "designation" : [
        {
          "language" : "de",
          "value" : "häuslicher Partner"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Registered domestic partner",
      "definition" : "Registered domestic partner",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Single",
      "definition" : "Single",
      "designation" : [
        {
          "language" : "de",
          "value" : "allein lebend"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Unreported",
      "definition" : "Unreported",
      "designation" : [
        {
          "language" : "de",
          "value" : "keine Angabe"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "W",
      "display" : "Widowed",
      "definition" : "Widowed",
      "designation" : [
        {
          "language" : "de",
          "value" : "verwitwet"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
