# Cumulative Dosage Limit UoM (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cumulative Dosage Limit UoM (2.8 - 1.0.0)**

## CodeSystem: Cumulative Dosage Limit UoM (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/cumulativeDosageLimitUom | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:CumulativeDosageLimitUom |
| *Other Identifiers:*OID:2.16.840.1.113883.18.430 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit. Used in HL7 Version 2.x messaging in the CDO segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScumulativeDosageLimitUom](ValueSet-hl7VScumulativeDosageLimitUom.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cumulativeDosageLimitUom",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0924"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/cumulativeDosageLimitUom",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.430"
    }
  ],
  "version" : "1.0.0",
  "name" : "CumulativeDosageLimitUom",
  "title" : "Cumulative Dosage Limit UoM (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit.  Used in HL7 Version 2.x messaging in the CDO segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Annual",
      "definition" : "Annual",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Per Day",
      "definition" : "Per Day",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Per Month",
      "definition" : "Per Month",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Duration of the Order",
      "definition" : "Duration of the Order",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Not from UCUM"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PL",
      "display" : "Patients Lifetime",
      "definition" : "Patients Lifetime",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Not fromUCUM"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "WK",
      "display" : "Per Week",
      "definition" : "Per Week",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    }
  ]
}

```
