# Confidentiality Code (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Confidentiality Code (2.8 - 1.0.0)**

## CodeSystem: Confidentiality Code (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/confidentialityCodes | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ConfidentialityCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.92 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation. Used in HL7 Version 2.x messaging in the OM1 and ORC segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSconfidentialityCode](ValueSet-hl7VSconfidentialityCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "confidentialityCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0177"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/confidentialityCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.92"
    }
  ],
  "version" : "1.0.0",
  "name" : "ConfidentialityCodes",
  "title" : "Confidentiality Code (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation.  Used in HL7 Version 2.x messaging in the OM1 and ORC segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AID",
      "display" : "AIDS patient",
      "definition" : "AIDS patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "AIDS-Patient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "EMP",
      "display" : "Employee",
      "definition" : "Employee",
      "designation" : [
        {
          "language" : "de",
          "value" : "Mitarbeiter"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ETH",
      "display" : "Alcohol/drug treatment patient",
      "definition" : "Alcohol/drug treatment patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Alkohol-/medikamentenabhängiger Patient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "HIV",
      "display" : "HIV(+) patient",
      "definition" : "HIV(+) patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "HIV-positiver Patient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PSY",
      "display" : "Psychiatric patient",
      "definition" : "Psychiatric patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Psychatriepatient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Restricted",
      "definition" : "Restricted",
      "designation" : [
        {
          "language" : "de",
          "value" : "vertraulich"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Usual control",
      "definition" : "Usual control",
      "designation" : [
        {
          "language" : "de",
          "value" : "normaler Zugriff"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UWM",
      "display" : "Unwed mother",
      "definition" : "Unwed mother",
      "designation" : [
        {
          "language" : "de",
          "value" : "unverheiratete Mutter"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Very restricted",
      "definition" : "Very restricted",
      "designation" : [
        {
          "language" : "de",
          "value" : "streng vertraulich"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "VIP",
      "display" : "Very important person or celebrity",
      "definition" : "Very important person or celebrity",
      "designation" : [
        {
          "language" : "de",
          "value" : "VIP"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
