# Universal ID Type (2.8 - 1.2.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Universal ID Type (2.8 - 1.2.0)**

## CodeSystem: Universal ID Type (2.8 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/universalIdType | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:UniversalIdType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.186 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of types of UID (Universal Identifiers). Used in HL7 Version 2.x messaging HD and EI datatypes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSuniversalIdType](ValueSet-hl7VSuniversalIdType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "universalIdType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0301"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/universalIdType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.186"
    }
  ],
  "version" : "1.2.0",
  "name" : "UniversalIdType",
  "title" : "Universal ID Type (2.8 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of types of UID (Universal Identifiers).   Used in HL7 Version 2.x messaging HD and EI datatypes.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CLIA",
      "display" : "Clinical Laboratory Improvement Amendments",
      "definition" : "Clinical Laboratory Improvement Amendments. Allows for the ability to designate organization identifier as a \"CLIA\" assigned number (for labs)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Allows for the ability to designate organization identifier as a “CLIA” assigned number (for labs)"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CLIP",
      "display" : "Clinical laboratory Improvement Program",
      "definition" : "Clinical laboratory Improvement Program. Allows for the ability to designate organization identifier as a \"CLIP\" assigned number (for labs).Â  Used by US Department of Defense.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Allows for the ability to designate organization identifier as a “CLIP” assigned number (for labs).  Used by US Department of Defense."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "DNS",
      "display" : "Domain Name System",
      "definition" : "An Internet host name, in accordance with RFC 1035; or an IP address. Either in ASCII or as integers, with periods between components (\"dotted\" notation).",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "An Internet host name, in accordance with RFC 1035; or an IP address. Either in ASCII or as integers, with periods between components (“dotted” notation)."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EUI64",
      "display" : "IEEE 64-bit Extended Unique Identifier",
      "definition" : "IEEE 64-bit Extended Unique Identifier is comprised of a  24-bit company identifier and a 40-bit instance identifier.  The value shall be formatted as 16 ASCII HEX digits, for example, \"AABBCC1122334455\".  The 24-bit company identifier, formally known as ",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "IEEE 64-bit Extended Unique Identifier is comprised of a  24-bit company identifier and a 40-bit instance identifier.  The value shall be formatted as 16 ASCII HEX digits, for example, “AABBCC1122334455”.  The 24-bit company identifier, formally known as Organizationally Unique Identifier (OUI-24), is guaranteed to be globally unique.  The 40-bit extensions are assigned by manufacturers.  This identifier is often used in equipment interfaces (e.g., “MAC” address format for IPv4 & IPv6).  [See http://standards.ieee.org/regauth/oui/tutorials/EUI64.htmlfor a detailed explanation of the format.]OUI-24 values are administered by the IEEE Registration Authority."
        },
        {
          "code" : "usage",
          "valueString" : "OUI-24 values are administered by the IEEE Registration Authority."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "GUID",
      "display" : "globally unique identifier",
      "definition" : "Same as UUID.",
      "designation" : [
        {
          "language" : "de",
          "value" : "GUID"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Same as UUID.Retained for backward compatibility only as of v2.7; use UUID instead"
        },
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility only as of v2.7; use UUID instead"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HCD",
      "display" : "CEN Healthcare Coding Identifier",
      "definition" : "The CEN Healthcare Coding Scheme Designator",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The CEN Healthcare Coding Scheme Designator. Retained for backward compatibility only as of v2.7; does not identify Assigning Authorities"
        },
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility only as of v2.7; does not identify Assigning Authorities"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HL7",
      "display" : "HL7 registration schemes",
      "definition" : "HL7 registration schemes",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Retained for backward compatibility only as of v2.7; HL7 assigns ISO OIDs for Assigning Authorities"
        },
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility only as of v2.7; HL7 assigns ISO OIDs for Assigning Authorities"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ISO",
      "display" : "ISO Object Identifier",
      "definition" : "An International Standards Organization Object Identifier (OID), in accordance with ISO/IEC 8824.  Formatted as decimal digits separated by periods; recommended limit of 64 characters",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "An International Standards Organization Object Identifier (OID), in accordance with ISO/IEC 8824.  Formatted as decimal digits separated by periods; recommended limit of 64 characters"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Local",
      "definition" : "These are reserved for locally defined coding schemes.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Locally defined coding entity identifier.Retained for backward compatibility only as of v 2.8"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Local",
      "definition" : "These are reserved for locally defined coding schemes.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Locally defined coding entity identifier.Retained for backward compatibility only as of v 2.8"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Local",
      "definition" : "These are reserved for locally defined coding schemes.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Locally defined coding entity identifier.Retained for backward compatibility only as of v 2.8"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "Random",
      "display" : "Random",
      "definition" : "Usually a base64 encoded string of random bits.<p>Note: Random IDs are typically used for instance identifiers, rather than an identifier of an Assigning Authority that issues instance identifiers",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Usually a base64 encoded string of random bits.Retained for backward compatibility only as of v2.7; equivalent to a locally defined entity identifier scheme; use L. M, or N instead. Note: Random IDs are typically used for instance identifiers, rather than an identifier of an Assigning Authority that issues instance identifiers"
        },
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility only as of v2.7; equivalent to a locally defined entity identifier scheme; use L. M, or N instead."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "URI",
      "display" : "Uniform Resource Identifier",
      "definition" : "Uniform Resource Identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "URI"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UUID",
      "display" : "Universal Unique Identifier",
      "definition" : "The DCE Universal Unique Identifier, in accordance with RFC 4122. Recommended format is 32 hexadecimal digits separated by hyphens, in the digit grouping 8-4-4-4-12",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The DCE Universal Unique Identifier, in accordance with RFC 4122. Recommended format is 32 hexadecimal digits separated by hyphens, in the digit grouping 8-4-4-4-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "x400",
      "display" : "X.400 MHS identifier",
      "definition" : "An X.400 MHS identifier. Recommended format is in accordance with RFC 1649",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Recommended format is in accordance with RFC 1649"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "x500",
      "display" : "X500 directory Name",
      "definition" : "An X.500 directory name",
      "designation" : [
        {
          "language" : "de",
          "value" : "X.500 Verzeichnis­name"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
