# Packaging Status Code (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Packaging Status Code (2.8 - 1.0.0)**

## CodeSystem: Packaging Status Code (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/packagingStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:PackagingStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.298 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the packaging status of the service. Used in HL7 Version 2.x messaging in the GP2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpackagingStatusCode](ValueSet-hl7VSpackagingStatusCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "packagingStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0469"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/packagingStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.298"
    }
  ],
  "version" : "1.0.0",
  "name" : "PackagingStatus",
  "title" : "Packaging Status Code (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the packaging status of the service.  Used in HL7 Version 2.x messaging in the GP2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "0",
      "display" : "Not packaged",
      "definition" : "Not packaged",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "1",
      "display" : "Packaged service (status indicator N, or no HCPCS code and certain revenue codes)",
      "definition" : "Packaged service (status indicator N, or no HCPCS code and certain revenue codes)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "Packaged as part of partial hospitalization per diem or daily mental health service per diem",
      "definition" : "Packaged as part of partial hospitalization per diem or daily mental health service per diem",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
