# Diagnosis Classification (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Diagnosis Classification (2.8 - 1.0.0)**

## CodeSystem: Diagnosis Classification (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/diagnosisClassification | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:DiagnosisClassification |
| *Other Identifiers:*OID:2.16.840.1.113883.18.128 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to classify whether a patient visit can be related to a diagnosis. Used in HL7 Version 2.x messaging in the DG1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdiagnosisClassification](ValueSet-hl7VSdiagnosisClassification.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "diagnosisClassification",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0228"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/diagnosisClassification",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.128"
    }
  ],
  "version" : "1.0.0",
  "name" : "DiagnosisClassification",
  "title" : "Diagnosis Classification (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to classify whether a patient visit can be related to a diagnosis.  Used in HL7 Version 2.x messaging in the DG1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Consultation",
      "definition" : "Consultation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Diagnosis",
      "definition" : "Diagnosis",
      "designation" : [
        {
          "language" : "de",
          "value" : "Diagnose"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Invasive procedure not classified elsewhere (I.V., catheter, etc.)",
      "definition" : "Invasive procedure not classified elsewhere (I.V., catheter, etc.)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Maßnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Medication (antibiotic)",
      "definition" : "Medication (antibiotic)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Medikation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "andere"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Radiological scheduling (not using ICDA codes)",
      "definition" : "Radiological scheduling (not using ICDA codes)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Planung von radiologischen Untersuchungen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Sign and symptom",
      "definition" : "Sign and symptom",
      "designation" : [
        {
          "language" : "de",
          "value" : "Symptome"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Tissue diagnosis",
      "definition" : "Tissue diagnosis",
      "designation" : [
        {
          "language" : "de",
          "value" : "Gewebebestimmung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
