# Causality Observations (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Causality Observations (2.8 - 1.0.0)**

## CodeSystem: Causality Observations (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/causalityObservations | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:CausalityObservations |
| *Other Identifiers:*OID:2.16.840.1.113883.18.147 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event. Used in HL7 Version 2.x messaging in the PCR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScausalityObservations](ValueSet-hl7VScausalityObservations.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "causalityObservations",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0252"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/causalityObservations",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.147"
    }
  ],
  "version" : "1.0.0",
  "name" : "CausalityObservations",
  "title" : "Causality Observations (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event.  Used in HL7 Version 2.x messaging in the PCR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AW",
      "display" : "Abatement of event after product withdrawn",
      "definition" : "Abatement of event after product withdrawn",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BE",
      "display" : "Event recurred after product reintroduced",
      "definition" : "Event recurred after product reintroduced",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DR",
      "display" : "Dose response observed",
      "definition" : "Dose response observed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EX",
      "display" : "Alternative explanations for the event available",
      "definition" : "Alternative explanations for the event available",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "Event occurred after product introduced",
      "definition" : "Event occurred after product introduced",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Literature reports association of product with event",
      "definition" : "Literature reports association of product with event",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OE",
      "display" : "Occurrence of event was confirmed by objective evidence",
      "definition" : "Occurrence of event was confirmed by objective evidence",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OT",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PL",
      "display" : "Effect observed when patient receives placebo",
      "definition" : "Effect observed when patient receives placebo",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SE",
      "display" : "Similar events in past for this patient",
      "definition" : "Similar events in past for this patient",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TC",
      "display" : "Toxic levels of product documented in blood or body fluids",
      "definition" : "Toxic levels of product documented in blood or body fluids",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
