# Blood Product Dispense Status (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Blood Product Dispense Status (2.8 - 1.0.0)**

## CodeSystem: Blood Product Dispense Status (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/bloodProductDispenseStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:BloodProductDispenseStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.333 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the filler or placer. For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product. When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been "dispensed". Used in the Blood Product Dispense Status (BPX) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSbloodProductDispenseStatus](ValueSet-hl7VSbloodProductDispenseStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "bloodProductDispenseStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0510"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/bloodProductDispenseStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.333"
    }
  ],
  "version" : "1.0.0",
  "name" : "BloodProductDispenseStatus",
  "title" : "Blood Product Dispense Status (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the filler or placer.  For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product.  When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been \"dispensed\".  Used in the Blood Product Dispense Status (BPX) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CR",
      "display" : "Released into inventory for general availability",
      "definition" : "Released into inventory for general availability",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DS",
      "display" : "Dispensed to patient location",
      "definition" : "Dispensed to patient location",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PT",
      "display" : "Presumed transfused (dispensed and not returned)",
      "definition" : "Presumed transfused (dispensed and not returned)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RA",
      "display" : "Returned unused/no longer needed",
      "definition" : "Returned unused/no longer needed",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RD",
      "display" : "Reserved and ready to dispense",
      "definition" : "Reserved and ready to dispense",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RE",
      "display" : "Released (no longer allocated for the patient)",
      "definition" : "Released (no longer allocated for the patient)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Placer or Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RI",
      "display" : "Received into inventory (for specified patient)",
      "definition" : "Received into inventory (for specified patient)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RL",
      "display" : "Returned unused/keep linked to patient for possible use later",
      "definition" : "Returned unused/keep linked to patient for possible use later",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RQ",
      "display" : "Request to dispense blood product",
      "definition" : "Request to dispense blood product",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Placer"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RS",
      "display" : "Reserved (ordered and product allocated for the patient)",
      "definition" : "Reserved (ordered and product allocated for the patient)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WA",
      "display" : "Wasted (product no longer viable)",
      "definition" : "Wasted (product no longer viable)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Status determined by Filler"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
