# Specimen Collection Method (2.7.1 - 1.0.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Collection Method (2.7.1 - 1.0.0)**

## CodeSystem: Specimen Collection Method (2.7.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenCollectionMethod | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:SpecimenCollectionMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.18.312 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the specimen collection method. Used in HL7 Version 2.x messaging in the SPM segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSspecimenCollectionMethod](ValueSet-hl7VSspecimenCollectionMethod.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specimenCollectionMethod",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0488"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenCollectionMethod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.312"
    }
  ],
  "version" : "1.0.0",
  "name" : "SpecimenCollectionMethod",
  "title" : "Specimen Collection Method (2.7.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the specimen collection method.  Used in HL7 Version 2.x messaging in the SPM segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ANP",
      "display" : "Plates, Anaerobic",
      "definition" : "Plates, Anaerobic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BAP",
      "display" : "Plates, Blood Agar",
      "definition" : "Plates, Blood Agar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BCAE",
      "display" : "Blood Culture, Aerobic Bottle",
      "definition" : "Blood Culture, Aerobic Bottle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BCAN",
      "display" : "Blood Culture, Anaerobic Bottle",
      "definition" : "Blood Culture, Anaerobic Bottle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BCPD",
      "display" : "Blood Culture, Pediatric Bottle",
      "definition" : "Blood Culture, Pediatric Bottle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BIO",
      "display" : "Biopsy",
      "definition" : "Biopsy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CAP",
      "display" : "Capillary Specimen",
      "definition" : "Capillary Specimen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CATH",
      "display" : "Catheterized",
      "definition" : "Catheterized",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CVP",
      "display" : "Line, CVP",
      "definition" : "Line, CVP",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EPLA",
      "display" : "Environmental, Plate",
      "definition" : "Environmental, Plate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ESWA",
      "display" : "Environmental, Swab",
      "definition" : "Environmental, Swab",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FNA",
      "display" : "Aspiration, Fine Needle",
      "definition" : "Aspiration, Fine Needle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "KOFFP",
      "display" : "Plate, Cough",
      "definition" : "Plate, Cough",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LNA",
      "display" : "Line, Arterial",
      "definition" : "Line, Arterial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LNV",
      "display" : "Line, Venous",
      "definition" : "Line, Venous",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MARTL",
      "display" : "Martin-Lewis Agar",
      "definition" : "Martin-Lewis Agar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ML11",
      "display" : "Mod. Martin-Lewis Agar",
      "definition" : "Mod. Martin-Lewis Agar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MLP",
      "display" : "Plate, Martin-Lewis",
      "definition" : "Plate, Martin-Lewis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NYP",
      "display" : "Plate, New York City",
      "definition" : "Plate, New York City",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PACE",
      "display" : "Pace, Gen-Probe",
      "definition" : "Pace, Gen-Probe",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PIN",
      "display" : "Pinworm Prep",
      "definition" : "Pinworm Prep",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PNA",
      "display" : "Arterial puncture",
      "definition" : "Arterial puncture",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRIME",
      "display" : "Pump Prime",
      "definition" : "Pump Prime",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PUMP",
      "display" : "Pump Specimen",
      "definition" : "Pump Specimen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "QC5",
      "display" : "Quality Control For Micro",
      "definition" : "Quality Control For Micro",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCLP",
      "display" : "Scalp, Fetal Vein",
      "definition" : "Scalp, Fetal Vein",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCRAPS",
      "display" : "Scrapings",
      "definition" : "Scrapings",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SHA",
      "display" : "Shaving",
      "definition" : "Shaving",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SWA",
      "display" : "Swab",
      "definition" : "Swab",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SWD",
      "display" : "Swab, Dacron tipped",
      "definition" : "Swab, Dacron tipped",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMAN",
      "display" : "Transport Media, Anaerobic",
      "definition" : "Transport Media, Anaerobic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMCH",
      "display" : "Transport Media, Chalamydia",
      "definition" : "Transport Media, Chalamydia",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMM4",
      "display" : "Transport Media, M4",
      "definition" : "Transport Media, M4",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMMY",
      "display" : "Transport Media, Mycoplasma",
      "definition" : "Transport Media, Mycoplasma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMOT",
      "display" : "Transport Media,",
      "definition" : "Transport Media,",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMP",
      "display" : "Plate, Thayer-Martin",
      "definition" : "Plate, Thayer-Martin",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMPV",
      "display" : "Transport Media, PVA",
      "definition" : "Transport Media, PVA",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMSC",
      "display" : "Transport Media, Stool Culture",
      "definition" : "Transport Media, Stool Culture",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMUP",
      "display" : "Transport Media, Ureaplasma",
      "definition" : "Transport Media, Ureaplasma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TMVI",
      "display" : "Transport Media, Viral",
      "definition" : "Transport Media, Viral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VENIP",
      "display" : "Venipuncture",
      "definition" : "Venipuncture",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WOOD",
      "display" : "Swab, Wooden Shaft",
      "definition" : "Swab, Wooden Shaft",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
