# Specimen Action Code (2.7.1 - 2.1.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Action Code (2.7.1 - 2.1.0)**

## CodeSystem: Specimen Action Code (2.7.1 - 2.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenAction | *Version*:2.1.0 |
| Active as of 2026-01-27 | *Computable Name*:SpecimenAction |
| *Other Identifiers:*OID:2.16.840.1.113883.18.25 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specimenAction",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0065"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenAction",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.25"
    }
  ],
  "version" : "2.1.0",
  "name" : "SpecimenAction",
  "title" : "Specimen Action Code (2.7.1 - 2.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx).  Used in HL7 Version 2.x messaging in the OBR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Add ordered tests to the existing specimen",
      "definition" : "Add ordered tests to the existing specimen",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zusätzliche Tests zur vorhandenen Probe"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Cancel order for battery or tests named",
      "definition" : "Cancel order for battery or tests named",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornoauftrag zu bekannter Probe"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "G",
      "display" : "Generated order; reflex order",
      "definition" : "Generated order; reflex order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nachgeordneter Auftrag / Auftrag als Reaktion auf Untersuchungsergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Lab to obtain specimen from patient",
      "definition" : "Lab to obtain specimen from patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Holauftrag für Labor"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Specimen obtained by service other than Lab",
      "definition" : "Specimen obtained by service other than Lab",
      "designation" : [
        {
          "language" : "de",
          "value" : "Probe wird / wurde mit dem Auftrag zur Verfügung gestellt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Pending specimen; Order sent prior to delivery",
      "definition" : "Pending specimen; Order sent prior to delivery",
      "designation" : [
        {
          "language" : "de",
          "value" : "Probe steht noch aus - Auftrag liegt schon vor"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Revised order",
      "definition" : "Revised order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geänderter Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Schedule the tests specified below",
      "definition" : "Schedule the tests specified below",
      "designation" : [
        {
          "language" : "de",
          "value" : "Spezifizierte Untersuchungen einplanen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
