# Patient Class (2.7.1 - 1.2.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Class (2.7.1 - 1.2.0)**

## CodeSystem: Patient Class (2.7.1 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/patientClass | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:PatientClass |
| *Other Identifiers:*OID:2.16.840.1.113883.18.5 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpatientClass](ValueSet-hl7VSpatientClass.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "patientClass",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0004"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/patientClass",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.5"
    }
  ],
  "version" : "1.2.0",
  "name" : "PatientClass",
  "title" : "Patient Class (2.7.1 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Obstetrics",
      "definition" : "Obstetrics",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geburtshilfe"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Commercial Account",
      "definition" : "Commercial Account",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Emergency",
      "definition" : "Emergency",
      "designation" : [
        {
          "language" : "de",
          "value" : "Notfall"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Inpatient",
      "definition" : "Inpatient",
      "designation" : [
        {
          "language" : "de",
          "value" : "stationär"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Not Applicable",
      "definition" : "Not Applicable",
      "designation" : [
        {
          "language" : "de",
          "value" : "Segment nicht anwendbar"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Outpatient",
      "definition" : "Outpatient",
      "designation" : [
        {
          "language" : "de",
          "value" : "ambulant"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Preadmit",
      "definition" : "Preadmit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Voraufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Recurring patient",
      "definition" : "Recurring patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wiederholungspatient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
