# Name/Address Representation (2.7.1 - 1.0.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Name/Address Representation (2.7.1 - 1.0.0)**

## CodeSystem: Name/Address Representation (2.7.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/name-addressRepresentation | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Name-addressRepresentation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.295 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying an indication of the representation provided by the data item. Used in HL7 Version 2.x messaging in the PPN, XAD, XCN and XON segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSname-addressRepresentation](ValueSet-hl7VSname-addressRepresentation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "name-addressRepresentation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0465"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/name-addressRepresentation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.295"
    }
  ],
  "version" : "1.0.0",
  "name" : "Name-addressRepresentation",
  "title" : "Name/Address Representation (2.7.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying an indication of the representation provided by the data item.  Used in HL7 Version 2.x messaging in the PPN, XAD, XCN and XON segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Alphabetic (i.e., Default or some single-byte)",
      "definition" : "Alphabetic (i.e., Default or some single-byte)",
      "designation" : [
        {
          "language" : "de",
          "value" : "alphabetisch"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Ideographic (i.e., Kanji)",
      "definition" : "Ideographic (i.e., Kanji)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)",
      "definition" : "Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
