# Extended Priority Codes (2.7.1 - 1.0.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Extended Priority Codes (2.7.1 - 1.0.0)**

## CodeSystem: Extended Priority Codes (2.7.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/extendedPriorityCodes | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ExtendedPriorityCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.310 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts describing the urgency of a request carried in an order. Used in HL7 Version 2.x messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSextendedPriorityCodes](ValueSet-hl7VSextendedPriorityCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "extendedPriorityCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0485"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/extendedPriorityCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.310"
    }
  ],
  "version" : "1.0.0",
  "name" : "ExtendedPriorityCodes",
  "title" : "Extended Priority Codes (2.7.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts describing the urgency of a request carried in an order.  Used in HL7 Version 2.x messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn).",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : true,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "ASAP",
      "definition" : "ASAP",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Fill after S orders"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Callback",
      "definition" : "Callback",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Preop",
      "definition" : "Preop",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRN",
      "display" : "As needed",
      "definition" : "As needed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Routine",
      "definition" : "Routine",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Default"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Stat",
      "definition" : "Stat",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "With highest priority"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Timing critical",
      "definition" : "Timing critical",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "A request implying that it is critical to come as close as possible to the requested time, e.g., for a trough anti-microbial level."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TD<integer>",
      "display" : "Timing critical within <integer> days.",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Timing critical within <integer> days."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TH<integer>",
      "display" : "Timing critical within <integer> hours.",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Timing critical within <integer> hours."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TL<integer>",
      "display" : "Timing critical within <integer> months.",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Timing critical within <integer> months."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TM<integer>",
      "display" : "Timing critical within <integer> minutes.",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Timing critical within <integer> minutes."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TS<integer>",
      "display" : "Timing critical within <integer> seconds.",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Timing critical within <integer> seconds."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TW<integer>",
      "display" : "Timing critical within <integer> weeks.",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Timing critical within <integer> weeks."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
