# Allergen Type (2.7.1 - 1.1.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Allergen Type (2.7.1 - 1.1.0)**

## CodeSystem: Allergen Type (2.7.1 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/allergenType | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:AllergenType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.54 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.). Used in HL7 Version 2.x messaging in the AL1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSallergyType](ValueSet-hl7VSallergyType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "allergenType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0127"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/allergenType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.54"
    }
  ],
  "version" : "1.1.0",
  "name" : "AllergenType",
  "title" : "Allergen Type (2.7.1 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.).  Used in HL7 Version 2.x messaging in the AL1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AA",
      "display" : "Animal Allergy",
      "definition" : "Animal Allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Tierallergie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DA",
      "display" : "Drug Allergy",
      "definition" : "Drug allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Medikamentenallergie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "EA",
      "display" : "Environmental Allergy",
      "definition" : "Environmental Allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Allergie gegen Umwelteinflüsse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FA",
      "display" : "Food Allergy",
      "definition" : "Food allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nahrungsmittelallergie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "LA",
      "display" : "Pollen Allergy",
      "definition" : "Pollen Allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Pollenallergie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Miscellaneous Allergy",
      "definition" : "Miscellaneous allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sonstige Allergie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "MC",
      "display" : "Miscellaneous Contraindication",
      "definition" : "Miscellaneous contraindication",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sonstige Kontraindikation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Plant Allergy",
      "definition" : "Plant Allergy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Pflanzenallergie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
