# Religion (2.7.1 - 2.1.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Religion (2.7.1 - 2.1.0)**

## CodeSystem: Religion (2.7.1 - 2.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/religion2 | *Version*:2.1.0 |
| Active as of 2026-01-27 | *Computable Name*:Religion2 |
| *Other Identifiers:*OID:2.16.840.1.113883.18.8 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying a person's religion. Used in HL7 Version 2.x messaging in the PID segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSreligion2](ValueSet-hl7VSreligion2.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "religion2",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0006"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/religion2",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.8"
    }
  ],
  "version" : "2.1.0",
  "name" : "Religion2",
  "title" : "Religion (2.7.1 - 2.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying a person's religion.    Used in HL7 Version 2.x messaging in the PID segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSreligion2"
        }
      ],
      "code" : "parent",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#parent",
      "description" : "parent",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ABC",
      "display" : "Christian: American Baptist Church",
      "definition" : "Christian: American Baptist Church",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AGN",
      "display" : "Agnostic",
      "definition" : "Agnostic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AME",
      "display" : "Christian: African Methodist Episcopal Zion",
      "definition" : "Christian: African Methodist Episcopal Zion",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AMT",
      "display" : "Christian: African Methodist Episcopal",
      "definition" : "Christian: African Methodist Episcopal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ANG",
      "display" : "Christian: Anglican",
      "definition" : "Christian: Anglican",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AOG",
      "display" : "Christian: Assembly of God",
      "definition" : "Christian: Assembly of God",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ATH",
      "display" : "Atheist",
      "definition" : "Atheist",
      "designation" : [
        {
          "language" : "de",
          "value" : "Atheist"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BAH",
      "display" : "Baha'i",
      "definition" : "Baha'i",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BAP",
      "display" : "Christian: Baptist",
      "definition" : "Christian: Baptist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BMA",
      "display" : "Buddhist: Mahayana",
      "definition" : "Buddhist: Mahayana",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BOT",
      "display" : "Buddhist: Other",
      "definition" : "Buddhist: Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BRE",
      "display" : "Brethren",
      "definition" : "Brethren",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "BTA",
      "display" : "Buddhist: Tantrayana",
      "definition" : "Buddhist: Tantrayana",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BTH",
      "display" : "Buddhist: Theravada",
      "definition" : "Buddhist: Theravada",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BUD",
      "display" : "Buddhist",
      "definition" : "Buddhist",
      "designation" : [
        {
          "language" : "de",
          "value" : "Buddhist"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CAT",
      "display" : "Christian: Roman Catholic",
      "definition" : "Christian: Roman Catholic",
      "designation" : [
        {
          "language" : "de",
          "value" : "römisch-katholisch"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CFR",
      "display" : "Chinese Folk Religionist",
      "definition" : "Chinese Folk Religionist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CHR",
      "display" : "Christian",
      "definition" : "Christian",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CHS",
      "display" : "Christian: Christian Science",
      "definition" : "Christian: Christian Science",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CMA",
      "display" : "Christian: Christian Missionary Alliance",
      "definition" : "Christian: Christian Missionary Alliance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CNF",
      "display" : "Confucian",
      "definition" : "Confucian",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COC",
      "display" : "Christian: Church of Christ",
      "definition" : "Christian: Church of Christ",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COG",
      "display" : "Christian: Church of God",
      "definition" : "Christian: Church of God",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COI",
      "display" : "Christian: Church of God in Christ",
      "definition" : "Christian: Church of God in Christ",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COL",
      "display" : "Christian: Congregational",
      "definition" : "Christian: Congregational",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COM",
      "display" : "Christian: Community",
      "definition" : "Christian: Community",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COP",
      "display" : "Christian: Other Pentecostal",
      "definition" : "Christian: Other Pentecostal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "COT",
      "display" : "Christian: Other",
      "definition" : "Christian: Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CRR",
      "display" : "Christian: Christian Reformed",
      "definition" : "Christian: Christian Reformed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DOC",
      "display" : "Disciples of Christ",
      "definition" : "Disciples of Christ",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EOT",
      "display" : "Christian: Eastern Orthodox",
      "definition" : "Christian: Eastern Orthodox",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EPI",
      "display" : "Christian: Episcopalian",
      "definition" : "Christian: Episcopalian",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ERL",
      "display" : "Ethnic Religionist",
      "definition" : "Ethnic Religionist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EVC",
      "display" : "Christian: Evangelical Church",
      "definition" : "Christian: Evangelical Church",
      "designation" : [
        {
          "language" : "de",
          "value" : "evangelisch"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FRQ",
      "display" : "Christian: Friends",
      "definition" : "Christian: Friends",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FUL",
      "display" : "Christian: Full Gospel",
      "definition" : "Christian: Full Gospel",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "FWB",
      "display" : "Christian: Free Will Baptist",
      "definition" : "Christian: Free Will Baptist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "GRE",
      "display" : "Christian: Greek Orthodox",
      "definition" : "Christian: Greek Orthodox",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HIN",
      "display" : "Hindu",
      "definition" : "Hindu",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hindu"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HOT",
      "display" : "Hindu: Other",
      "definition" : "Hindu: Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HSH",
      "display" : "Hindu: Shaivites",
      "definition" : "Hindu: Shaivites",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HVA",
      "display" : "Hindu: Vaishnavites",
      "definition" : "Hindu: Vaishnavites",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JAI",
      "display" : "Jain",
      "definition" : "Jain",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JCO",
      "display" : "Jewish: Conservative",
      "definition" : "Jewish: Conservative",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JEW",
      "display" : "Jewish",
      "definition" : "Jewish",
      "designation" : [
        {
          "language" : "de",
          "value" : "jüdisch"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JOR",
      "display" : "Jewish: Orthodox",
      "definition" : "Jewish: Orthodox",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JOT",
      "display" : "Jewish: Other",
      "definition" : "Jewish: Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JRC",
      "display" : "Jewish: Reconstructionist",
      "definition" : "Jewish: Reconstructionist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JRF",
      "display" : "Jewish: Reform",
      "definition" : "Jewish: Reform",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JRN",
      "display" : "Jewish: Renewal",
      "definition" : "Jewish: Renewal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JWN",
      "display" : "Christian: Jehovah's Witness",
      "definition" : "Christian: Jehovah's Witness",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LMS",
      "display" : "Christian: Lutheran Missouri Synod",
      "definition" : "Christian: Lutheran Missouri Synod",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LUT",
      "display" : "Christian: Lutheran",
      "definition" : "Christian: Lutheran",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEN",
      "display" : "Christian: Mennonite",
      "definition" : "Christian: Mennonite",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MET",
      "display" : "Christian: Methodist",
      "definition" : "Christian: Methodist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MOM",
      "display" : "Christian: Latter-day Saints",
      "definition" : "Christian: Latter-day Saints",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MOS",
      "display" : "Muslim",
      "definition" : "Muslim",
      "designation" : [
        {
          "language" : "de",
          "value" : "Muslim"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MOT",
      "display" : "Muslim: Other",
      "definition" : "Muslim: Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MSH",
      "display" : "Muslim: Shiite",
      "definition" : "Muslim: Shiite",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MSU",
      "display" : "Muslim: Sunni",
      "definition" : "Muslim: Sunni",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NAM",
      "display" : "Native American",
      "definition" : "Native American",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NAZ",
      "display" : "Christian: Church of the Nazarene",
      "definition" : "Christian: Church of the Nazarene",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NOE",
      "display" : "Nonreligious",
      "definition" : "Nonreligious",
      "designation" : [
        {
          "language" : "de",
          "value" : "nicht-religiös"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NRL",
      "display" : "New Religionist",
      "definition" : "New Religionist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ORT",
      "display" : "Christian: Orthodox",
      "definition" : "Christian: Orthodox",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "andere"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PEN",
      "display" : "Christian: Pentecostal",
      "definition" : "Christian: Pentecostal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRC",
      "display" : "Christian: Other Protestant",
      "definition" : "Christian: Other Protestant",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRE",
      "display" : "Christian: Presbyterian",
      "definition" : "Christian: Presbyterian",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRO",
      "display" : "Christian: Protestant",
      "definition" : "Christian: Protestant",
      "designation" : [
        {
          "language" : "de",
          "value" : "Protestant"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "REC",
      "display" : "Christian: Reformed Church",
      "definition" : "Christian: Reformed Church",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "REO",
      "display" : "Christian: Reorganized Church of Jesus Christ-LDS",
      "definition" : "Christian: Reorganized Church of Jesus Christ-LDS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SAA",
      "display" : "Christian: Salvation Army",
      "definition" : "Christian: Salvation Army",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SEV",
      "display" : "Christian: Seventh Day Adventist",
      "definition" : "Christian: Seventh Day Adventist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SHN",
      "display" : "Shintoist",
      "definition" : "Shintoist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SIK",
      "display" : "Sikh",
      "definition" : "Sikh",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sikh"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SOU",
      "display" : "Christian: Southern Baptist",
      "definition" : "Christian: Southern Baptist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SPI",
      "display" : "Spiritist",
      "definition" : "Spiritist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UCC",
      "display" : "Christian: United Church of Christ",
      "definition" : "Christian: United Church of Christ",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UMD",
      "display" : "Christian: United Methodist",
      "definition" : "Christian: United Methodist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UNI",
      "display" : "Christian: Unitarian",
      "definition" : "Christian: Unitarian",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UNU",
      "display" : "Christian: Unitarian Universalist",
      "definition" : "Christian: Unitarian Universalist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "VAR",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "WES",
      "display" : "Christian: Wesleyan",
      "definition" : "Christian: Wesleyan",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "WMC",
      "display" : "Christian: Wesleyan Methodist",
      "definition" : "Christian: Wesleyan Methodist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
