# Processing Consideration Codes (2.7.1 - 1.0.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Processing Consideration Codes (2.7.1 - 1.0.0)**

## CodeSystem: Processing Consideration Codes (2.7.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/processingConsideration | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ProcessingConsideration |
| *Other Identifiers:*OID:2.16.840.1.113883.18.365 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer). Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSprocessingConsiderationCodes](ValueSet-hl7VSprocessingConsiderationCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "processingConsideration",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0562"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/processingConsideration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.365"
    }
  ],
  "version" : "1.0.0",
  "name" : "ProcessingConsideration",
  "title" : "Processing Consideration Codes (2.7.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer).  Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "DFADJ",
      "display" : "Deferred Adjudication Processing",
      "definition" : "Deferred Adjudication Processing",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "If permitted by Payer"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EFORM",
      "display" : "Electronic form to follow",
      "definition" : "Electronic form to follow",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "E30 transaction to follow"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "FAX",
      "display" : "Fax to follow",
      "definition" : "Fax to follow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PAPER",
      "display" : "Paper documentation to follow",
      "definition" : "Paper documentation to follow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PYRDELAY",
      "display" : "Delayed by a Previous Payer",
      "definition" : "Delayed by a Previous Payer",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Allows Provider to explain lateness of Invoice to a subsequent Payer"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RTADJ",
      "display" : "Real Time Adjudication Processing",
      "definition" : "Real Time Adjudication Processing",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "If permitted by Payer"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
