# Document Availability Status (2.7.1 - 1.1.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Availability Status (2.7.1 - 1.1.0)**

## CodeSystem: Document Availability Status (2.7.1 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/documentAvailabilityStatus | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:DocumentAvailabilityStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.167 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care. Used in HL7 Version 2.x messaging in the TXA segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdocumentAvailabilityStatus](ValueSet-hl7VSdocumentAvailabilityStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "documentAvailabilityStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0273"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/documentAvailabilityStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.167"
    }
  ],
  "version" : "1.1.0",
  "name" : "DocumentAvailabilityStatus",
  "title" : "Document Availability Status (2.7.1 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care.  Used in HL7 Version 2.x messaging in the TXA segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AV",
      "display" : "Available for patient care",
      "definition" : "Available for patient care",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verfügbar (Kann zur Behandlung herangezogen werden.)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Deleted",
      "definition" : "Deleted",
      "designation" : [
        {
          "language" : "de",
          "value" : "Gelöscht"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OB",
      "display" : "Obsolete",
      "definition" : "Obsolete",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht mehr relevant"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "UN",
      "display" : "Unavailable for patient care",
      "definition" : "Unavailable for patient care",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht verfügbar (Kann nicht zur Behandlung verwendet werden.)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
