# Allow Substitution Codes (2.7.1 - 1.1.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Allow Substitution Codes (2.7.1 - 1.1.0)**

## CodeSystem: Allow Substitution Codes (2.7.1 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/allowSubstitution | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:AllowSubstitution |
| *Other Identifiers:*OID:2.16.840.1.113883.18.172 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the AIS and AIG segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSallowSubstitution](ValueSet-hl7VSallowSubstitution.md)
* [Hl7VSallowSubstitutionCodes](ValueSet-hl7VSallowSubstitutionCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "allowSubstitution",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0279"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/allowSubstitution",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.172"
    }
  ],
  "version" : "1.1.0",
  "name" : "AllowSubstitution",
  "title" : "Allow Substitution Codes (2.7.1 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the AIS and AIG segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : false,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "Confirm",
      "display" : "Contact the Placer Contact Person prior to making any substitutions of this resource",
      "definition" : "Contact the Placer Contact Person prior to making any substitutions of this resource",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "No",
      "display" : "Substitution of this resource is not allowed",
      "definition" : "Substitution of this resource is not allowed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Notify",
      "display" : "Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made",
      "definition" : "Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Yes",
      "display" : "Substitution of this resource is allowed",
      "definition" : "Substitution of this resource is allowed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
