# Admission Type (2.7.1 - 1.1.0) - HL7 v2.7.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Admission Type (2.7.1 - 1.1.0)**

## CodeSystem: Admission Type (2.7.1 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/admissionType | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:AdmissionType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.9 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the circumstances under which the patient was or will be admitted. Used in HL7 Version 2.x messaging in the PV1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSadmissionType](ValueSet-hl7VSadmissionType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "admissionType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0007"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/admissionType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.9"
    }
  ],
  "version" : "1.1.0",
  "name" : "AdmissionType",
  "title" : "Admission Type (2.7.1 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:48:36+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the circumstances under which the patient was or will be admitted.  Used in HL7 Version 2.x messaging in the PV1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Accident",
      "definition" : "Accident",
      "designation" : [
        {
          "language" : "de",
          "value" : "Unfall / Notarztwagen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Elective",
      "definition" : "Elective",
      "designation" : [
        {
          "language" : "de",
          "value" : "wahlfreie Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Emergency",
      "definition" : "Emergency",
      "designation" : [
        {
          "language" : "de",
          "value" : "Notfall ohne Einweisung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Labor and Delivery",
      "definition" : "Labor and Delivery",
      "designation" : [
        {
          "language" : "de",
          "value" : "Entbindung / Geburt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Newborn (Birth in healthcare facility)",
      "definition" : "Newborn (Birth in healthcare facility)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Neugeborenes"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Routine",
      "definition" : "Routine",
      "designation" : [
        {
          "language" : "de",
          "value" : "Normalaufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Urgent",
      "definition" : "Urgent",
      "designation" : [
        {
          "language" : "de",
          "value" : "dringliche Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
