# Vaccines Administered (2.7 - 1.5.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vaccines Administered (2.7 - 1.5.0)**

## ValueSet: Vaccines Administered (2.7 - 1.5.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/ValueSet/PHVS_VaccinesAdministeredCVX_CDC_NIP | *Version*:1.5.0 |
| Active as of 2026-01-27 | *Computable Name*:PHVS_VaccinesAdministeredCVX_CDC_NIP |
| *Other Identifiers:*OID:2.16.840.1.114222.4.11.934 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Value Set of codes that specify the administered vaccines. The values are maintained by the US Centers of Disease Control.. The code system is maintained by the CDC, and may be found at URL; https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.1 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "PHVS_VaccinesAdministeredCVX_CDC_NIP",
  "url" : "http://terminology.hl7.org/v2plusvocab/ValueSet/PHVS_VaccinesAdministeredCVX_CDC_NIP",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.114222.4.11.934"
    }
  ],
  "version" : "1.5.0",
  "name" : "PHVS_VaccinesAdministeredCVX_CDC_NIP",
  "title" : "Vaccines Administered (2.7 - 1.5.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Value Set of codes that specify the administered vaccines.   The values are maintained by the US Centers of Disease Control..  The code system is maintained by the CDC, and may be found at URL;  https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.1",
  "copyright" : "HL7 Inc., 2026",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/PH_VaccinesAdministeredCVX_CDC_NIP",
        "version" : "0"
      }
    ]
  }
}

```
