# TQ Conjunction ID (2.7 - 1.1.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TQ Conjunction ID (2.7 - 1.1.0)**

## CodeSystem: TQ Conjunction ID (2.7 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/tqConjunctionId | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:TqConjunctionId |
| *Other Identifiers:*OID:2.16.840.1.113883.18.300 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying that a second timing specification is to follow using the repeat delimiter. Used in HL7 Version 2.x messaging in the TQ1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStqConjunctionId](ValueSet-hl7VStqConjunctionId.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "tqConjunctionId",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0472"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/tqConjunctionId",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.300"
    }
  ],
  "version" : "1.1.0",
  "name" : "TqConjunctionId",
  "title" : "TQ Conjunction ID (2.7 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying that a second timing specification is to follow using the repeat delimiter.  Used in HL7 Version 2.x messaging in the TQ1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Asynchronous",
      "definition" : "Asynchronous",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Do the next specification in parallel with this one (unless otherwise constrained by the following fields: TQ1-7-start date/time and TQ1-8-end date/time).  The conjunction of \"A\" specifies two parallel instructions, as are sometimes used in medication, e."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Actuation Time",
      "definition" : "Actuation Time",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "It will be followed by a completion time for the service.  This code allows one to distinguish between the time and priority at which a service should be actuated (e.g., blood should be drawn) and the time and priority at which a service should be complet"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Synchronous",
      "definition" : "Synchronous",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Do the next specification after this one (unless otherwise constrained by the following fields: TQ1-7-start date/time and TQ1-8-end date/time). An “S” specification implies that the second timing sequence follows the first, e.g., when an order is written to measure blood pressure Q15 minutes for the 1st hour, then every 2 hours for the next day."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
