# Security Check Scheme (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Security Check Scheme (2.7 - 1.0.0)**

## CodeSystem: Security Check Scheme (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/securityCheckScheme | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:SecurityCheckScheme |
| *Other Identifiers:*OID:2.16.840.1.113883.18.415 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the scheme for the security check. Used in HL7 Version 2.x messaging in the CX datatypes and PPN and XCN segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsecurityCheckScheme](ValueSet-hl7VSsecurityCheckScheme.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "securityCheckScheme",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0904"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/securityCheckScheme",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.415"
    }
  ],
  "version" : "1.0.0",
  "name" : "SecurityCheckScheme",
  "title" : "Security Check Scheme (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the scheme for the security check.  Used in HL7 Version 2.x messaging in the CX datatypes and PPN and XCN segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "BCV",
      "display" : "Bank Card Validation Number",
      "definition" : "Bank Card Validation Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "A non-embossed number included on bank cards and used to validate authenticity of the card and the person presenting the card"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CCS",
      "display" : "Credit Card Security code",
      "definition" : "Credit Card Security code",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "VID",
      "display" : "Version ID",
      "definition" : "Version ID",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
