# Relationship (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Relationship (2.7 - 1.0.0)**

## CodeSystem: Relationship (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/relationship | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Relationship |
| *Other Identifiers:*OID:2.16.840.1.113883.18.24 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying an actual personal relationship that the next of kin/associated party has to a patient. Used in HL7 Version 2.x messaging in the NK1 and IN1 segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSrelationship](ValueSet-hl7VSrelationship.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "relationship",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0063"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/relationship",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.24"
    }
  ],
  "version" : "1.0.0",
  "name" : "Relationship",
  "title" : "Relationship (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying an actual personal relationship that the next of kin/associated party has to a patient.  Used in HL7 Version 2.x messaging in the NK1 and IN1 segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ASC",
      "display" : "Associate",
      "definition" : "Associate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BRO",
      "display" : "Brother",
      "definition" : "Brother",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bruder"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CGV",
      "display" : "Care giver",
      "definition" : "Care giver",
      "designation" : [
        {
          "language" : "de",
          "value" : "Pflegeeltern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CHD",
      "display" : "Child",
      "definition" : "Child",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kind"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DEP",
      "display" : "Handicapped dependent",
      "definition" : "Handicapped dependent",
      "designation" : [
        {
          "language" : "de",
          "value" : "Begleitperson für Hilfsbedürftige"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DOM",
      "display" : "Life partner",
      "definition" : "Life partner",
      "designation" : [
        {
          "language" : "de",
          "value" : "Lebenspartner"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EMC",
      "display" : "Emergency contact",
      "definition" : "Emergency contact",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ansprechpartner in Notfällen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EME",
      "display" : "Employee",
      "definition" : "Employee",
      "designation" : [
        {
          "language" : "de",
          "value" : "Angestellter"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EMR",
      "display" : "Employer",
      "definition" : "Employer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitgeber"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EXF",
      "display" : "Extended family",
      "definition" : "Extended family",
      "designation" : [
        {
          "language" : "de",
          "value" : "erweiterter Familienkreis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FCH",
      "display" : "Foster child",
      "definition" : "Foster child",
      "designation" : [
        {
          "language" : "de",
          "value" : "Pflegekind"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FND",
      "display" : "Friend",
      "definition" : "Friend",
      "designation" : [
        {
          "language" : "de",
          "value" : "Freund"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FTH",
      "display" : "Father",
      "definition" : "Father",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vater"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "GCH",
      "display" : "Grandchild",
      "definition" : "Grandchild",
      "designation" : [
        {
          "language" : "de",
          "value" : "Enkel"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "GRD",
      "display" : "Guardian",
      "definition" : "Guardian",
      "designation" : [
        {
          "language" : "de",
          "value" : "Pate"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "GRP",
      "display" : "Grandparent",
      "definition" : "Grandparent",
      "designation" : [
        {
          "language" : "de",
          "value" : "Großeltern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MGR",
      "display" : "Manager",
      "definition" : "Manager",
      "designation" : [
        {
          "language" : "de",
          "value" : "Manager"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MTH",
      "display" : "Mother",
      "definition" : "Mother",
      "designation" : [
        {
          "language" : "de",
          "value" : "Mutter"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NCH",
      "display" : "Natural child",
      "definition" : "Natural child",
      "designation" : [
        {
          "language" : "de",
          "value" : "eigenes Kind"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NON",
      "display" : "None",
      "definition" : "None",
      "designation" : [
        {
          "language" : "de",
          "value" : "keine"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OAD",
      "display" : "Other adult",
      "definition" : "Other adult",
      "designation" : [
        {
          "language" : "de",
          "value" : "anderer Erwachsener"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "andere"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OWN",
      "display" : "Owner",
      "definition" : "Owner",
      "designation" : [
        {
          "language" : "de",
          "value" : "Eigentümer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PAR",
      "display" : "Parent",
      "definition" : "Parent",
      "designation" : [
        {
          "language" : "de",
          "value" : "Eltern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SCH",
      "display" : "Stepchild",
      "definition" : "Stepchild",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stiefkind"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SEL",
      "display" : "Self",
      "definition" : "Self",
      "designation" : [
        {
          "language" : "de",
          "value" : "selbst"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SIB",
      "display" : "Sibling",
      "definition" : "Sibling",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geschwister"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SIS",
      "display" : "Sister",
      "definition" : "Sister",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schwester"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SPO",
      "display" : "Spouse",
      "definition" : "Spouse",
      "designation" : [
        {
          "language" : "de",
          "value" : "Partner"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TRA",
      "display" : "Trainer",
      "definition" : "Trainer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Trainer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "WRD",
      "display" : "Ward of court",
      "definition" : "Ward of court",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vormund"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
