# Kind of Quantity (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Kind of Quantity (2.7 - 1.0.0)**

## CodeSystem: Kind of Quantity (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/kindOfQuantity | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:KindOfQuantity |
| *Other Identifiers:*OID:2.16.840.1.113883.18.149 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation. These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth. These are discussed more fully in the LOINC Users’ Manual. These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book. These distinctions are used in IUPAC and LOINC standard codes. Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSkindOfQuantity](ValueSet-hl7VSkindOfQuantity.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "kindOfQuantity",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0254"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/kindOfQuantity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.149"
    }
  ],
  "version" : "1.0.0",
  "name" : "KindOfQuantity",
  "title" : "Kind of Quantity (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation.  These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth.  These are discussed more fully in the LOINC Users’ Manual.   These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book.  These distinctions are used in IUPAC and LOINC standard codes.  Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ABS",
      "display" : "Absorbance",
      "definition" : "Absorbance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ACNC",
      "display" : "Concentration, Arbitrary Substance",
      "definition" : "Concentration, Arbitrary Substance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ACT",
      "display" : "Activity",
      "definition" : "Activity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "APER",
      "display" : "Appearance",
      "definition" : "Appearance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ARB",
      "display" : "Arbitrary",
      "definition" : "Arbitrary",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AREA",
      "display" : "Area",
      "definition" : "Area",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ASPECT",
      "display" : "Aspect",
      "definition" : "Aspect",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CACT",
      "display" : "Catalytic Activity",
      "definition" : "Catalytic Activity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CCNT",
      "display" : "Catalytic Content",
      "definition" : "Catalytic Content",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CCRTO",
      "display" : "Catalytic Concentration Ratio",
      "definition" : "Catalytic Concentration Ratio",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CFR",
      "display" : "Catalytic Fraction",
      "definition" : "Catalytic Fraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CLAS",
      "display" : "Class",
      "definition" : "Class",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CNC",
      "display" : "Catalytic Concentration",
      "definition" : "Catalytic Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CNST",
      "display" : "Constant",
      "definition" : "Constant",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "COEF",
      "display" : "Coefficient",
      "definition" : "Coefficient",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "COLOR",
      "display" : "Color",
      "definition" : "Color",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CONS",
      "display" : "Consistency",
      "definition" : "Consistency",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CRAT",
      "display" : "Catalytic Rate",
      "definition" : "Catalytic Rate",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CRTO",
      "display" : "Catalytic Ratio",
      "definition" : "Catalytic Ratio",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DEN",
      "display" : "Density",
      "definition" : "Density",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DEV",
      "display" : "Device",
      "definition" : "Device",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DIFF",
      "display" : "Difference",
      "definition" : "Difference",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ELAS",
      "display" : "Elasticity",
      "definition" : "Elasticity",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ELPOT",
      "display" : "Electrical Potential (Voltage)",
      "definition" : "Electrical Potential (Voltage)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ELRAT",
      "display" : "Electrical current (amperage)",
      "definition" : "Electrical current (amperage)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ELRES",
      "display" : "Electrical Resistance",
      "definition" : "Electrical Resistance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ENGR",
      "display" : "Energy",
      "definition" : "Energy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ENT",
      "display" : "Entitic",
      "definition" : "Entitic",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ENTCAT",
      "display" : "Entitic Catalytic Activity",
      "definition" : "Entitic Catalytic Activity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ENTNUM",
      "display" : "Entitic Number",
      "definition" : "Entitic Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ENTSUB",
      "display" : "Entitic Substance of Amount",
      "definition" : "Entitic Substance of Amount",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ENTVOL",
      "display" : "Entitic Volume",
      "definition" : "Entitic Volume",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EQL",
      "display" : "Equilibrium",
      "definition" : "Equilibrium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FORCE",
      "display" : "Mechanical force",
      "definition" : "Mechanical force",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FREQ",
      "display" : "Frequency",
      "definition" : "Frequency",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IMP",
      "display" : "Impression/ interpretation of study",
      "definition" : "Impression/ interpretation of study",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "KINV",
      "display" : "Kinematic Viscosity",
      "definition" : "Kinematic Viscosity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LEN",
      "display" : "Length",
      "definition" : "Length",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LINC",
      "display" : "Length Increment",
      "definition" : "Length Increment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LIQ",
      "display" : "Liquefaction",
      "definition" : "Liquefaction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MASS",
      "display" : "Mass",
      "definition" : "Mass",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MCNC",
      "display" : "Mass Concentration",
      "definition" : "Mass Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MCNT",
      "display" : "Mass Content",
      "definition" : "Mass Content",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MCRTO",
      "display" : "Mass Concentration Ratio",
      "definition" : "Mass Concentration Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MFR",
      "display" : "Mass Fraction",
      "definition" : "Mass Fraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MGFLUX",
      "display" : "Magnetic flux",
      "definition" : "Magnetic flux",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MINC",
      "display" : "Mass Increment",
      "definition" : "Mass Increment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MORPH",
      "display" : "Morphology",
      "definition" : "Morphology",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MOTIL",
      "display" : "Motility",
      "definition" : "Motility",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MRAT",
      "display" : "Mass Rate",
      "definition" : "Mass Rate",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MRTO",
      "display" : "Mass Ratio",
      "definition" : "Mass Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NCNC",
      "display" : "Number Concentration",
      "definition" : "Number Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NCNT",
      "display" : "Number Content",
      "definition" : "Number Content",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NFR",
      "display" : "Number Fraction",
      "definition" : "Number Fraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NRTO",
      "display" : "Number Ratio",
      "definition" : "Number Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NUM",
      "display" : "Number",
      "definition" : "Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OD",
      "display" : "Optical density",
      "definition" : "Optical density",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OSMOL",
      "display" : "Osmolality",
      "definition" : "Osmolality",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PRES",
      "display" : "Pressure (Partial)",
      "definition" : "Pressure (Partial)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PRID",
      "display" : "Presence/Identity/Existence",
      "definition" : "Presence/Identity/Existence",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PWR",
      "display" : "Power (wattage)",
      "definition" : "Power (wattage)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RANGE",
      "display" : "Ranges",
      "definition" : "Ranges",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RATIO",
      "display" : "Ratios",
      "definition" : "Ratios",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RCRLTM",
      "display" : "Reciprocal Relative Time",
      "definition" : "Reciprocal Relative Time",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RDEN",
      "display" : "Relative Density",
      "definition" : "Relative Density",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "REL",
      "display" : "Relative",
      "definition" : "Relative",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RLMCNC",
      "display" : "Relative Mass Concentration",
      "definition" : "Relative Mass Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RLSCNC",
      "display" : "Relative Substance Concentration",
      "definition" : "Relative Substance Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RLTM",
      "display" : "Relative Time",
      "definition" : "Relative Time",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SATFR",
      "display" : "Saturation Fraction",
      "definition" : "Saturation Fraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SCNC",
      "display" : "Substance Concentration",
      "definition" : "Substance Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SCNCIN",
      "display" : "Substance Concentration Increment",
      "definition" : "Substance Concentration Increment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SCNT",
      "display" : "Substance Content",
      "definition" : "Substance Content",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SCNTR",
      "display" : "Substance Content Rate",
      "definition" : "Substance Content Rate",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SCRTO",
      "display" : "Substance Concentration Ratio",
      "definition" : "Substance Concentration Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SFR",
      "display" : "Substance Fraction",
      "definition" : "Substance Fraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SHAPE",
      "display" : "Shape",
      "definition" : "Shape",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SMELL",
      "display" : "Smell",
      "definition" : "Smell",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SRAT",
      "display" : "Substance Rate",
      "definition" : "Substance Rate",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SRTO",
      "display" : "Substance Ratio",
      "definition" : "Substance Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SUB",
      "display" : "Substance Amount",
      "definition" : "Substance Amount",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SUSC",
      "display" : "Susceptibility",
      "definition" : "Susceptibility",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TASTE",
      "display" : "Taste",
      "definition" : "Taste",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TEMP",
      "display" : "Temperature",
      "definition" : "Temperature",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TEMPDF",
      "display" : "Temperature Difference",
      "definition" : "Temperature Difference",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TEMPIN",
      "display" : "Temperature Increment",
      "definition" : "Temperature Increment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "THRMCNC",
      "display" : "Threshold Mass Concentration",
      "definition" : "Threshold Mass Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "THRSCNC",
      "display" : "Threshold Substance Concentration",
      "definition" : "Threshold Substance Concentration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TIME",
      "display" : "Time (e.g. seconds)",
      "definition" : "Time (e.g. seconds)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TITR",
      "display" : "Dilution Factor (Titer)",
      "definition" : "Dilution Factor (Titer)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TMDF",
      "display" : "Time Difference",
      "definition" : "Time Difference",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TMSTP",
      "display" : "Time Stamp-Date and Time",
      "definition" : "Time Stamp-Date and Time",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TRTO",
      "display" : "Time Ratio",
      "definition" : "Time Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TYPE",
      "display" : "Type",
      "definition" : "Type",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VCNT",
      "display" : "Volume Content",
      "definition" : "Volume Content",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VEL",
      "display" : "Velocity",
      "definition" : "Velocity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VELRT",
      "display" : "Velocity Ratio",
      "definition" : "Velocity Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VFR",
      "display" : "Volume Fraction",
      "definition" : "Volume Fraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VISC",
      "display" : "Viscosity",
      "definition" : "Viscosity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VOL",
      "display" : "Volume",
      "definition" : "Volume",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VRAT",
      "display" : "Volume Rate",
      "definition" : "Volume Rate",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VRTO",
      "display" : "Volume Ratio",
      "definition" : "Volume Ratio",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Adopted from the IUPAC Silver Book 1995” to the code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
