# Consent Type (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent Type (2.7 - 1.0.0)**

## CodeSystem: Consent Type (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/consentType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ConsentType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.320 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event. Used in HL7 Version 2.x messaging in the TXA and CON segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSconsentType](ValueSet-hl7VSconsentType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "consentType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0496"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/consentType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.320"
    }
  ],
  "version" : "1.0.0",
  "name" : "ConsentType",
  "title" : "Consent Type (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event.  Used in HL7 Version 2.x messaging in the TXA and CON segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "001",
      "display" : "Release of Information/MR / Authorization to Disclosure Protected Health Information",
      "definition" : "Release of Information/MR / Authorization to Disclosure Protected Health Information",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "002",
      "display" : "Medical Procedure (invasive)",
      "definition" : "Medical Procedure (invasive)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "003",
      "display" : "Acknowledge Receipt of Privacy Notice",
      "definition" : "Acknowledge Receipt of Privacy Notice",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Acknowledgement/ Notification"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "004",
      "display" : "Abortion",
      "definition" : "Abortion",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "005",
      "display" : "Abortion/Laminaria",
      "definition" : "Abortion/Laminaria",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "006",
      "display" : "Accutane - Information",
      "definition" : "Accutane - Information",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "007",
      "display" : "Accutane - Woman",
      "definition" : "Accutane - Woman",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "008",
      "display" : "Advanced Beneficiary Notice",
      "definition" : "Advanced Beneficiary Notice",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Acknowledgement/ Notification"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "009",
      "display" : "AFP (Alpha Fetoprotein) Screening",
      "definition" : "AFP (Alpha Fetoprotein) Screening",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "010",
      "display" : "Amniocentesis (consent & refusal)",
      "definition" : "Amniocentesis (consent & refusal)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "011",
      "display" : "Anatomical Gift (organ donation)",
      "definition" : "Anatomical Gift (organ donation)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "012",
      "display" : "Anesthesia - Complications",
      "definition" : "Anesthesia - Complications",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "013",
      "display" : "Anesthesia - Questionnaire",
      "definition" : "Anesthesia - Questionnaire",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "014",
      "display" : "Angiogram",
      "definition" : "Angiogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "015",
      "display" : "Angioplasty",
      "definition" : "Angioplasty",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "016",
      "display" : "Anticancer Drugs",
      "definition" : "Anticancer Drugs",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "017",
      "display" : "Antipsychotic Medications",
      "definition" : "Antipsychotic Medications",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "018",
      "display" : "Arthrogram",
      "definition" : "Arthrogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "019",
      "display" : "Autopsy",
      "definition" : "Autopsy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "020",
      "display" : "AZT Therapy",
      "definition" : "AZT Therapy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "021",
      "display" : "Biliary Drainage",
      "definition" : "Biliary Drainage",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "022",
      "display" : "Biliary Stone Extraction",
      "definition" : "Biliary Stone Extraction",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "023",
      "display" : "Biopsy",
      "definition" : "Biopsy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "024",
      "display" : "Bleeding Time Test",
      "definition" : "Bleeding Time Test",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "025",
      "display" : "Bronchogram",
      "definition" : "Bronchogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "026",
      "display" : "Cardiac Catheterization",
      "definition" : "Cardiac Catheterization",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "027",
      "display" : "Coronary Angiography",
      "definition" : "Coronary Angiography",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "028",
      "display" : "Coronary Angiography w/o Surgery Capability",
      "definition" : "\"\"      \"\" w/o Surgery Capability",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-09-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "029",
      "display" : "Cataract Op/Implant of FDA Aprvd Lens",
      "definition" : "Cataract Op/Implant of FDA Aprvd Lens",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "030",
      "display" : "Cataract Op/Implant of Investigational Lens",
      "definition" : "Cataract Op/Implant of Investigational Lens",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "031",
      "display" : "Cataract Surgery",
      "definition" : "Cataract Surgery",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "032",
      "display" : "Cholera Immunization",
      "definition" : "Cholera Immunization",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "033",
      "display" : "Cholesterol Screening",
      "definition" : "Cholesterol Screening",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "034",
      "display" : "Circumcision - Newborn",
      "definition" : "Circumcision - Newborn",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "035",
      "display" : "Colonoscopy",
      "definition" : "Colonoscopy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "036",
      "display" : "Contact Lenses",
      "definition" : "Contact Lenses",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "037",
      "display" : "CT Scan - Cervical & Lumbar",
      "definition" : "CT Scan - Cervical & Lumbar",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "038",
      "display" : "CT Scan w/ IV Contrast Media into Vein",
      "definition" : "CT Scan w/ IV Contrast Media into Vein",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "039",
      "display" : "CVS (Chorionic Villus) Sampling",
      "definition" : "CVS (Chorionic Villus) Sampling",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "040",
      "display" : "Cystospy",
      "definition" : "Cystospy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "041",
      "display" : "Disclosure of Protected Health Information to Family/Friends",
      "definition" : "Disclosure of Protected Health Information to Family/Friends",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "042",
      "display" : "D & C and Conization",
      "definition" : "D & C and Conization",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "043",
      "display" : "Dacryocystogram",
      "definition" : "Dacryocystogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "044",
      "display" : "Diagnostic Isotope",
      "definition" : "Diagnostic Isotope",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "045",
      "display" : "Drainage of an Abscess",
      "definition" : "Drainage of an Abscess",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "046",
      "display" : "Drug Screening",
      "definition" : "Drug Screening",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "047",
      "display" : "Electronic Monitoring of Labor - Refusal",
      "definition" : "Electronic Monitoring of Labor - Refusal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "048",
      "display" : "Endometrial Biopsy",
      "definition" : "Endometrial Biopsy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "049",
      "display" : "Endoscopy/Sclerosis of Esophageal Varices",
      "definition" : "Endoscopy/Sclerosis of Esophageal Varices",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "050",
      "display" : "ERCP",
      "definition" : "ERCP",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "051",
      "display" : "Exposure to reportable Communicable Disease",
      "definition" : "Exposure to reportable Communicable Disease",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "052",
      "display" : "External Version",
      "definition" : "External Version",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "053",
      "display" : "Fluorescein Angioscopy",
      "definition" : "Fluorescein Angioscopy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "054",
      "display" : "Hepatitis B - Consent/Declination",
      "definition" : "Hepatitis B - Consent/Declination",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "055",
      "display" : "Herniogram",
      "definition" : "Herniogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "056",
      "display" : "HIV Test - Consent Refusal",
      "definition" : "HIV Test - Consent Refusal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "057",
      "display" : "HIV Test - Disclosure",
      "definition" : "HIV Test - Disclosure",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "058",
      "display" : "HIV Test - Prenatal",
      "definition" : "HIV Test - Prenatal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "059",
      "display" : "Home IV Treatment Program",
      "definition" : "Home IV Treatment Program",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "060",
      "display" : "Home Parenteral Treatment Program",
      "definition" : "Home Parenteral Treatment Program",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "061",
      "display" : "Hysterectomy",
      "definition" : "Hysterectomy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "062",
      "display" : "Hysterosalpingogram",
      "definition" : "Hysterosalpingogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "063",
      "display" : "Injection Slip/ Consent",
      "definition" : "Injection Slip/ Consent",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "064",
      "display" : "Intrauterine Device",
      "definition" : "Intrauterine Device",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "065",
      "display" : "Intrauterine Device/Sterilization",
      "definition" : "Intrauterine Device/Sterilization",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "066",
      "display" : "Intravascular Infusion of Streptokinase/Urokinase",
      "definition" : "Intravascular Infusion of Streptokinase/Urokinase",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "067",
      "display" : "Intravenous Cholangiogram",
      "definition" : "Intravenous Cholangiogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "068",
      "display" : "Intravenous Digital Angiography",
      "definition" : "Intravenous Digital Angiography",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "069",
      "display" : "Iodine Administration",
      "definition" : "Iodine Administration",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "070",
      "display" : "ISG",
      "definition" : "ISG",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "071",
      "display" : "IVP",
      "definition" : "IVP",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "072",
      "display" : "Laser Photocoagulation",
      "definition" : "Laser Photocoagulation",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "073",
      "display" : "Laser treatment",
      "definition" : "Laser treatment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "074",
      "display" : "Lithium Carbonate",
      "definition" : "Lithium Carbonate",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "075",
      "display" : "Liver Biopsy",
      "definition" : "Liver Biopsy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "076",
      "display" : "Lumbar Puncture",
      "definition" : "Lumbar Puncture",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "077",
      "display" : "Lymphangiogram",
      "definition" : "Lymphangiogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "078",
      "display" : "MAO Inhibitors",
      "definition" : "MAO Inhibitors",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "079",
      "display" : "Med, Psych, and/or Drug/Alcohol",
      "definition" : "Med, Psych, and/or Drug/Alcohol",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "080",
      "display" : "Medical Treatment - Refusal",
      "definition" : "Medical Treatment - Refusal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "081",
      "display" : "Morning-after Pill",
      "definition" : "Morning-after Pill",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "082",
      "display" : "MRI - Adult",
      "definition" : "MRI - Adult",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "083",
      "display" : "MRI - Pediatric",
      "definition" : "MRI - Pediatric",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "084",
      "display" : "Myelogram",
      "definition" : "Myelogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "085",
      "display" : "Needle Biopsy",
      "definition" : "Needle Biopsy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "086",
      "display" : "Needle Biopsy of Lung",
      "definition" : "Needle Biopsy of Lung",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "087",
      "display" : "Newborn Treatment and Release",
      "definition" : "Newborn Treatment and Release",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "088",
      "display" : "Norplant Subdermal Birth Control Implant",
      "definition" : "Norplant Subdermal Birth Control Implant",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "089",
      "display" : "Operations, Anesthesia, Transfusions",
      "definition" : "Operations, Anesthesia, Transfusions",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "090",
      "display" : "Oral Contraceptives",
      "definition" : "Oral Contraceptives",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "091",
      "display" : "Organ Donation",
      "definition" : "Organ Donation",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "092",
      "display" : "Patient Permits, Consents",
      "definition" : "Patient Permits, Consents",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "093",
      "display" : "Patient Treatment Permit, Release & Admission",
      "definition" : "Patient Treatment Permit, Release & Admission",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "094",
      "display" : "Penile Injections",
      "definition" : "Penile Injections",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "095",
      "display" : "Percutaneous Nephrostomy",
      "definition" : "Percutaneous Nephrostomy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "096",
      "display" : "Percutaneous Transhepatic Cholangiogram",
      "definition" : "Percutaneous Transhepatic Cholangiogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "097",
      "display" : "Photographs",
      "definition" : "Photographs",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "098",
      "display" : "Photographs - Employee",
      "definition" : "Photographs - Employee",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "099",
      "display" : "Photographs - Medical Research",
      "definition" : "Photographs - Medical Research",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "100",
      "display" : "Photographs - news Media",
      "definition" : "Photographs - news Media",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "101",
      "display" : "Psychiatric Admission - Next of Kin",
      "definition" : "Psychiatric Admission - Next of Kin",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "102",
      "display" : "Psychiatric Information During Hospital Stay",
      "definition" : "Psychiatric Information During Hospital Stay",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "103",
      "display" : "Public Release of Information",
      "definition" : "Public Release of Information",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "104",
      "display" : "Radiologic Procedure",
      "definition" : "Radiologic Procedure",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "105",
      "display" : "Refusal of Treatment",
      "definition" : "Refusal of Treatment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "106",
      "display" : "Release of Body",
      "definition" : "Release of Body",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "107",
      "display" : "Release of Limb",
      "definition" : "Release of Limb",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "108",
      "display" : "Rh Immune Globulin",
      "definition" : "Rh Immune Globulin",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "109",
      "display" : "Rights of Medical Research Participants",
      "definition" : "Rights of Medical Research Participants",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "110",
      "display" : "Request to Restrict Access/Disclosure to Medical Record/Protected Health Information",
      "definition" : "Request to Restrict Access/Disclosure to Medical Record/Protected Health Information",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "111",
      "display" : "Request for Remain Anonymous",
      "definition" : "Request for Remain Anonymous",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "112",
      "display" : "Seat Belt Exemption",
      "definition" : "Seat Belt Exemption",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Administrative"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "113",
      "display" : "Sialogram",
      "definition" : "Sialogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "1137",
      "display" : "Voiding Cystogram",
      "definition" : "Voiding Cystogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "114",
      "display" : "Sigmoidoscopy",
      "definition" : "Sigmoidoscopy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "115",
      "display" : "Sterilization - Anesthesia & Medical Services",
      "definition" : "Sterilization - Anesthesia & Medical Services",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "116",
      "display" : "Sterilization -Federally Funded",
      "definition" : "Sterilization -Federally Funded",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "117",
      "display" : "Sterilization - Female",
      "definition" : "Sterilization - Female",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "118",
      "display" : "Sterilization - Laparoscopy/Pomeroy",
      "definition" : "Sterilization - Laparoscopy/Pomeroy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "119",
      "display" : "Sterilization - Non-Federally Funded",
      "definition" : "Sterilization - Non-Federally Funded",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "120",
      "display" : "Sterilization - Secondary",
      "definition" : "Sterilization - Secondary",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "121",
      "display" : "Tranquilizers",
      "definition" : "Tranquilizers",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "122",
      "display" : "Transfer - Acknowledgement",
      "definition" : "Transfer - Acknowledgement",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "123",
      "display" : "Transfer - Authorization",
      "definition" : "Transfer - Authorization",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "124",
      "display" : "Transfer Certification - Physician",
      "definition" : "Transfer Certification - Physician",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "125",
      "display" : "Transfer/Discharge Request",
      "definition" : "Transfer/Discharge Request",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "126",
      "display" : "Transfer for Non-Medical Reasons",
      "definition" : "Transfer for Non-Medical Reasons",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "127",
      "display" : "Transfer - Interfaculty Neonatal",
      "definition" : "Transfer - Interfaculty Neonatal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "128",
      "display" : "Transfer Refusal",
      "definition" : "Transfer Refusal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "129",
      "display" : "Transfer Refusal of Further Treatment",
      "definition" : "Transfer Refusal of Further Treatment",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "130",
      "display" : "Treadmill & EKG",
      "definition" : "Treadmill & EKG",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "131",
      "display" : "Treadmill, Thallium-201",
      "definition" : "Treadmill, Thallium-201",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "132",
      "display" : "Typhoid",
      "definition" : "Typhoid",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "133",
      "display" : "Use of Investigational Device",
      "definition" : "Use of Investigational Device",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "134",
      "display" : "Use of Investigational Drug",
      "definition" : "Use of Investigational Drug",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "135",
      "display" : "Venogram",
      "definition" : "Venogram",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Medical Treatment/ Procedure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "136",
      "display" : "Videotape",
      "definition" : "Videotape",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Release of Info/ Disclosure"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
