# Command Response (2.7 - 1.0.1) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Command Response (2.7 - 1.0.1)**

## CodeSystem: Command Response (2.7 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/commandResponse | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:CommandResponse |
| *Other Identifiers:*OID:2.16.840.1.113883.18.238 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts identifying the response of the previously issued command. Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScommandResponse](ValueSet-hl7VScommandResponse.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "commandResponse",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0387"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/commandResponse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.238"
    }
  ],
  "version" : "1.0.1",
  "name" : "CommandResponse",
  "title" : "Command Response (2.7 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts identifying the response of the previously issued command.  Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ER",
      "display" : "Command cannot be completed because of error condition",
      "definition" : "Command cannot be completed because of error condition",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "See response parameters."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OK",
      "display" : "Command completed successfully",
      "definition" : "Command completed successfully",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ST",
      "display" : "Command cannot be completed because of the status of the requested equipment",
      "definition" : "Command cannot be completed because of the status of the requested equipment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TI",
      "display" : "Command cannot be completed within requested completion time",
      "definition" : "Command cannot be completed within requested completion time",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UN",
      "display" : "Command cannot be completed for unknown reasons",
      "definition" : "Command cannot be completed for unknown reasons",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
