# ActPriority (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActPriority (2.7 - 1.0.0)**

## CodeSystem: ActPriority (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/actpriority | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Actpriority |
| *Other Identifiers:*OID:2.16.840.1.113883.18.417 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the priority for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSactpriority](ValueSet-hl7VSactpriority.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "actpriority",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0906"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/actpriority",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.417"
    }
  ],
  "version" : "1.0.0",
  "name" : "Actpriority",
  "title" : "ActPriority (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the priority for the shipment.  Used in HL7 Version 2.x messaging in the SHP segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "ASAP - As soon as possible, next highest priority after stat",
      "definition" : "ASAP - As soon as possible, next highest priority after stat",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Callback results - filler should contact the placer as soon as results are available, even for preliminary results",
      "definition" : "Callback results - filler should contact the placer as soon as results are available, even for preliminary results",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CS",
      "display" : "Callback for scheduling - Filler should contact the placer (or target) to schedule the service.",
      "definition" : "Callback for scheduling - Filler should contact the placer (or target) to schedule the service.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CSP",
      "display" : "Callback placer for scheduling - filler should contact the placer to schedule the service",
      "definition" : "Callback placer for scheduling - filler should contact the placer to schedule the service",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CSR",
      "display" : "Contact recipient for scheduling - Filler should contact the service recipient (target) to schedule the service",
      "definition" : "Contact recipient for scheduling - Filler should contact the service recipient (target) to schedule the service",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "EL",
      "display" : "Elective - Beneficial to the patient but not essential for survival.",
      "definition" : "Elective - Beneficial to the patient but not essential for survival.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "EM",
      "display" : "Emergency - An unforeseen combination of circumstances or the resulting state that calls for immediate action",
      "definition" : "Emergency - An unforeseen combination of circumstances or the resulting state that calls for immediate action",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Preop - Used to indicate that a service is to be performed prior to a scheduled surgery.  When ordering a service and using the pre-op priority, a check is done to see the amount of time that must be allowed for performance of the service.  When the order",
      "definition" : "Preop - Used to indicate that a service is to be performed prior to a scheduled surgery.  When ordering a service and using the pre-op priority, a check is done to see the amount of time that must be allowed for performance of the service.  When the order",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PRN",
      "display" : "As needed - An \"as needed\" order should be accompanied by a description of what constitutes a need.  This description is represented by an observation service predicate as a precondition.",
      "definition" : "As needed - An \"as needed\" order should be accompanied by a description of what constitutes a need.  This description is represented by an observation service predicate as a precondition.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Routine - Routine service, do at usual work hours",
      "definition" : "Routine - Routine service, do at usual work hours",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "Rush reporting - A report should be prepared and sent as quickly as possible",
      "definition" : "Rush reporting - A report should be prepared and sent as quickly as possible",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Stat - With highest priority (e.g. emergency).",
      "definition" : "Stat - With highest priority (e.g. emergency).",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Timing critical - It is critical to come as close as possible to the requested time (e.g. for a through antimicrobial level).",
      "definition" : "Timing critical - It is critical to come as close as possible to the requested time (e.g. for a through antimicrobial level).",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "UD",
      "display" : "Use as directed - Drug is to be used as directed by the prescriber.",
      "definition" : "Use as directed - Drug is to be used as directed by the prescriber.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "UR",
      "display" : "Urgent - Calls for prompt action",
      "definition" : "Urgent - Calls for prompt action",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
