# User Authentication Credential Type Code (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **User Authentication Credential Type Code (2.7 - 1.0.0)**

## CodeSystem: User Authentication Credential Type Code (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/userAuthenticationCredentialType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:UserAuthenticationCredentialType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.373 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying a type of user authentication credential. Used in HL7 Version 2.x messaging in the UAC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSuserAuthenticationCredentialTypeCode](ValueSet-hl7VSuserAuthenticationCredentialTypeCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "userAuthenticationCredentialType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0615"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/userAuthenticationCredentialType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.373"
    }
  ],
  "version" : "1.0.0",
  "name" : "UserAuthenticationCredentialType",
  "title" : "User Authentication Credential Type Code (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying a type of user authentication credential.  Used in HL7 Version 2.x messaging in the UAC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "KERB",
      "display" : "Kerberos Service Ticket",
      "definition" : "Kerberos Service Ticket",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Structure defined by RFC 1510"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "SAML",
      "display" : "Authenticated User Identity Assertion",
      "definition" : "Authenticated User Identity Assertion",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "XML structure defined by the OASIS Security Assertion Markup Language (SAML) specification"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
