# Transfusion Adverse Reaction (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Transfusion Adverse Reaction (2.7 - 1.0.0)**

## CodeSystem: Transfusion Adverse Reaction (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/transfusionAdverseReaction | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:TransfusionAdverseReaction |
| *Other Identifiers:*OID:2.16.840.1.113883.18.336 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify the type of adverse reaction that the recipient of the blood product experienced. Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStransfusionAdverseReaction](ValueSet-hl7VStransfusionAdverseReaction.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "transfusionAdverseReaction",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0514"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/transfusionAdverseReaction",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.336"
    }
  ],
  "version" : "1.0.0",
  "name" : "TransfusionAdverseReaction",
  "title" : "Transfusion Adverse Reaction (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the type of adverse reaction that the recipient of the blood product experienced.  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ABOINC",
      "display" : "ABO Incompatible Transfusion Reaction",
      "definition" : "ABO Incompatible Transfusion Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ACUTHEHTR",
      "display" : "Acute Hemolytic Transfusion Reaction",
      "definition" : "Acute Hemolytic Transfusion Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ALLERGIC1",
      "display" : "Allergic Reaction - First",
      "definition" : "Allergic Reaction - First",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ALLERGIC2",
      "display" : "Allergic Reaction - Recurrent",
      "definition" : "Allergic Reaction - Recurrent",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ALLERGICR",
      "display" : "Allergic Reaction - Repeating",
      "definition" : "Allergic Reaction - Repeating",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANAPHYLAC",
      "display" : "Anaphylactic Reaction",
      "definition" : "Anaphylactic Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BACTCONTAM",
      "display" : "Reaction to Bacterial Contamination",
      "definition" : "Reaction to Bacterial Contamination",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DELAYEDHTR",
      "display" : "Delayed Hemolytic Transfusion Reaction",
      "definition" : "Delayed Hemolytic Transfusion Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DELAYEDSTR",
      "display" : "Delayed Serological Transfusion Reaction",
      "definition" : "Delayed Serological Transfusion Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GVHD",
      "display" : "Graft vs Host Disease - Transfusion - Associated",
      "definition" : "Graft vs Host Disease - Transfusion - Associated",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HYPOTENS",
      "display" : "Non-hemolytic Hypotensive Reaction",
      "definition" : "Non-hemolytic Hypotensive Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NONHTR1",
      "display" : "Non-Hemolytic Fever Chill Transfusion Reaction - First",
      "definition" : "Non-Hemolytic Fever Chill Transfusion Reaction - First",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NONHTR2",
      "display" : "Non-Hemolytic Fever Chill Transfusion Reaction - Recurrent",
      "definition" : "Non-Hemolytic Fever Chill Transfusion Reaction - Recurrent",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NONHTRREC",
      "display" : "Non-Hemolytic Fever Chill Transfusion Reaction - Repeating",
      "definition" : "Non-Hemolytic Fever Chill Transfusion Reaction - Repeating",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NONIMMUNE",
      "display" : "Non-Immune Hemolysis",
      "definition" : "Non-Immune Hemolysis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NONSPEC",
      "display" : "Non-Specific, Non-Hemolytic Transfusion Reaction",
      "definition" : "Non-Specific, Non-Hemolytic Transfusion Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NORXN",
      "display" : "No Evidence of Transfusion Reaction",
      "definition" : "No Evidence of Transfusion Reaction",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PTP",
      "display" : "Posttransfusion Purpura",
      "definition" : "Posttransfusion Purpura",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VOLOVER",
      "display" : "Symptoms most likely due to volume overload",
      "definition" : "Symptoms most likely due to volume overload",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
