# Risk Management Incident Code (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Management Incident Code (2.7 - 1.0.0)**

## CodeSystem: Risk Management Incident Code (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/riskManagementIncident | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:RiskManagementIncident |
| *Other Identifiers:*OID:2.16.840.1.113883.18.268 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay. Used in HL7 Version 2 messaging in the RMI segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSriskManagementIncidentCode](ValueSet-hl7VSriskManagementIncidentCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "riskManagementIncident",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0427"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/riskManagementIncident",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.268"
    }
  ],
  "version" : "1.0.0",
  "name" : "RiskManagementIncident",
  "title" : "Risk Management Incident Code (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay.  Used in HL7 Version 2 messaging in the RMI segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Body fluid exposure",
      "definition" : "Body fluid exposure",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Contaminated Substance",
      "definition" : "Contaminated Substance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Diet Errors",
      "definition" : "Diet Errors",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Equipment problem",
      "definition" : "Equipment problem",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Patient fell (not from bed)",
      "definition" : "Patient fell (not from bed)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "Patient fell from bed",
      "definition" : "Patient fell from bed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Infusion error",
      "definition" : "Infusion error",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "J",
      "display" : "Foreign object left during surgery",
      "definition" : "Foreign object left during surgery",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "K",
      "display" : "Sterile precaution violated",
      "definition" : "Sterile precaution violated",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Procedure error",
      "definition" : "Procedure error",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Pharmaceutical error",
      "definition" : "Pharmaceutical error",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Suicide Attempt",
      "definition" : "Suicide Attempt",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Transfusion error",
      "definition" : "Transfusion error",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
