# Nature of Abnormal Testing (2.7 - 1.1.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nature of Abnormal Testing (2.7 - 1.1.0)**

## CodeSystem: Nature of Abnormal Testing (2.7 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/natureOfAbnormalTesting | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:NatureOfAbnormalTesting |
| *Other Identifiers:*OID:2.16.840.1.113883.18.32 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version 2.x messaging in the OBX segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSnatureOfAbnormalTesting](ValueSet-hl7VSnatureOfAbnormalTesting.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "natureOfAbnormalTesting",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0080"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/natureOfAbnormalTesting",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.32"
    }
  ],
  "version" : "1.1.0",
  "name" : "NatureOfAbnormalTesting",
  "title" : "Nature of Abnormal Testing (2.7 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the nature of an abnormal test.  Used in HL7 Version 2.x messaging in the OBX segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "An age-based population",
      "definition" : "An age-based population",
      "designation" : [
        {
          "language" : "de",
          "value" : "Altersabhängig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B",
      "display" : "Breed",
      "definition" : "Breed",
      "designation" : [
        {
          "language" : "de",
          "value" : "abhängig von Rasse oder Zucht"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "None - generic normal range",
      "definition" : "None - generic normal range",
      "designation" : [
        {
          "language" : "de",
          "value" : "Genereller Normalwert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "A race-based population",
      "definition" : "A race-based population",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rasseabhängig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "A sex-based population",
      "definition" : "A sex-based population",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geschlechtsabhängig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "SP",
      "display" : "Species",
      "definition" : "Species",
      "designation" : [
        {
          "language" : "de",
          "value" : "abhängig von Spezies"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ST",
      "display" : "Strain",
      "definition" : "Strain",
      "designation" : [
        {
          "language" : "de",
          "value" : "abhängig von Bakterienstamm"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
