# Military Service (2.7 - 1.1.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Military Service (2.7 - 1.1.0)**

## CodeSystem: Military Service (2.7 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/militaryService | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:MilitaryService |
| *Other Identifiers:*OID:2.16.840.1.113883.18.62 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the military branch. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmilitaryService](ValueSet-hl7VSmilitaryService.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "militaryService",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0140"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/militaryService",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.62"
    }
  ],
  "version" : "1.1.0",
  "name" : "MilitaryService",
  "title" : "Military Service (2.7 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify the military branch.  This field is defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the PD1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AUSA",
      "display" : "Australian Army",
      "definition" : "Australian Army",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AUSAF",
      "display" : "Australian Air Force",
      "definition" : "Australian Air Force",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AUSN",
      "display" : "Australian Navy",
      "definition" : "Australian Navy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NATO",
      "display" : "North Atlantic Treaty Organization",
      "definition" : "North Atlantic Treaty Organization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NOAA",
      "display" : "National Oceanic and Atmospheric Administration",
      "definition" : "National Oceanic and Atmospheric Administration",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "USA",
      "display" : "US Army",
      "definition" : "US Army",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "USAF",
      "display" : "US Air Force",
      "definition" : "US Air Force",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "USCG",
      "display" : "US Coast Guard",
      "definition" : "US Coast Guard",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "USMC",
      "display" : "US Marine Corps",
      "definition" : "US Marine Corps",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "USN",
      "display" : "US Navy",
      "definition" : "US Navy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "USPHS",
      "display" : "US Public Health Service",
      "definition" : "US Public Health Service",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
