# Invoice Processing Results Status (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Invoice Processing Results Status (2.7 - 1.0.0)**

## CodeSystem: Invoice Processing Results Status (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/invoiceProcessingResultsStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:InvoiceProcessingResultsStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.371 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify the processing status for an Invoice Processing Result. Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSinvoiceProcessingResultsStatus](ValueSet-hl7VSinvoiceProcessingResultsStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "invoiceProcessingResultsStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0571"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/invoiceProcessingResultsStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.371"
    }
  ],
  "version" : "1.0.0",
  "name" : "InvoiceProcessingResultsStatus",
  "title" : "Invoice Processing Results Status (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the processing status for an Invoice Processing Result.  Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ACK",
      "display" : "Acknowledge",
      "definition" : "Acknowledge",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ADJ",
      "display" : "Adjudicated with Adjustments",
      "definition" : "Adjudicated with Adjustments",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ADJSUB",
      "display" : "Adjudicated as Submitted",
      "definition" : "Adjudicated as Submitted",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ADJZER",
      "display" : "Adjudicated to Zero",
      "definition" : "Adjudicated to Zero",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PAID",
      "display" : "Paid",
      "definition" : "Paid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PEND",
      "display" : "Pending",
      "definition" : "Pending",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PRED",
      "display" : "Pre-Determination",
      "definition" : "Pre-Determination",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Indicates that the IPR has been adjudicated but will not be paid.  Equivalent to ADJUD (Adjudicate)"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "REJECT",
      "display" : "Reject",
      "definition" : "Reject",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
