# Data Types (2.7 - 1.1.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Data Types (2.7 - 1.1.0)**

## CodeSystem: Data Types (2.7 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/dataTypes | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:DataTypes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.280 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX). Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdataTypes](ValueSet-hl7VSdataTypes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "dataTypes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0440"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/dataTypes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.280"
    }
  ],
  "version" : "1.1.0",
  "name" : "DataTypes",
  "title" : "Data Types (2.7 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX).   Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "Address",
      "definition" : "Address",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "415"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AUI",
      "display" : "Authorization information",
      "definition" : "Authorization information",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "239"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CCD",
      "display" : "Charge code and date",
      "definition" : "Charge code and date",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "28"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CCP",
      "display" : "Channel calibration parameters",
      "definition" : "Channel calibration parameters",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "20"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CD",
      "display" : "Channel definition",
      "definition" : "Channel definition",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "581"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CE",
      "display" : "Coded element",
      "definition" : "Coded element",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "483"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CF",
      "display" : "Coded element with formatted values",
      "definition" : "Coded element with formatted values",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "65536"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CK",
      "display" : "Composite ID with check digit",
      "definition" : "Composite ID with check digit",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CM",
      "display" : "Composite",
      "definition" : "Composite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CN",
      "display" : "Composite ID number and name",
      "definition" : "Composite ID number and name",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CNE",
      "display" : "Coded with no exceptions",
      "definition" : "Coded with no exceptions",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "705"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CNN",
      "display" : "Composite ID number and name simplified",
      "definition" : "Composite ID number and name simplified",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "406"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Composite price",
      "definition" : "Composite price",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "543"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CQ",
      "display" : "Composite quantity with units",
      "definition" : "Composite quantity with units",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "500"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CSU",
      "display" : "Channel sensitivity and units",
      "definition" : "Channel sensitivity and units",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "490"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CWE",
      "display" : "Coded with exceptions",
      "definition" : "Coded with exceptions",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "705"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CX",
      "display" : "Extended composite ID with check digit",
      "definition" : "Extended composite ID with check digit",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "1913"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DDI",
      "display" : "Daily deductible information",
      "definition" : "Daily deductible information",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DIN",
      "display" : "Date and institution name",
      "definition" : "Date and institution name",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "510"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DLD",
      "display" : "Discharge to location and date",
      "definition" : "Discharge to location and date",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "47"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DLN",
      "display" : "Driver's license number",
      "definition" : "Driver's license number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "66"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DLT",
      "display" : "Delta",
      "definition" : "Delta",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "45"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DR",
      "display" : "Date/time range",
      "definition" : "Date/time range",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "53"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DT",
      "display" : "Date",
      "definition" : "Date",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "8"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DTM",
      "display" : "Date/time",
      "definition" : "Date/time",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "24"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DTN",
      "display" : "Day type and number",
      "definition" : "Day type and number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "6"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ED",
      "display" : "Encapsulated data",
      "definition" : "Encapsulated data",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "65536"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EI",
      "display" : "Entity identifier",
      "definition" : "Entity identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "427"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EIP",
      "display" : "Entity identifier pair",
      "definition" : "Entity identifier pair",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "855"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ELD",
      "display" : "Error location and description",
      "definition" : "Error location and description",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "493"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ERL",
      "display" : "Error location",
      "definition" : "Error location",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "18"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FC",
      "display" : "Financial class",
      "definition" : "Financial class",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "47"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FN",
      "display" : "Family name",
      "definition" : "Family name",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "194"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FT",
      "display" : "Formatted text",
      "definition" : "Formatted text",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "65536"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "GTS",
      "display" : "General timing specification",
      "definition" : "General timing specification",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "199"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HD",
      "display" : "Hierarchic designator",
      "definition" : "Hierarchic designator",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "227"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICD",
      "display" : "Insurance certification definition",
      "definition" : "Insurance certification definition",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "40"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ID",
      "display" : "Coded values for HL7 tables",
      "definition" : "Coded values for HL7 tables",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Variable"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IS",
      "display" : "Coded value for user-defined tables",
      "definition" : "Coded value for user-defined tables",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "20"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JCC",
      "display" : "Job code/class",
      "definition" : "Job code/class",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "292"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LA1",
      "display" : "Location with address variation 1",
      "definition" : "Location with address variation 1",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "415"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LA2",
      "display" : "Location with address variation 2",
      "definition" : "Location with address variation 2",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "790"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Multiplexed array",
      "definition" : "Multiplexed array",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "65536"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MO",
      "display" : "Money",
      "definition" : "Money",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "20"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MOC",
      "display" : "Money and charge code",
      "definition" : "Money and charge code",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "504"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MOP",
      "display" : "Money or percentage",
      "definition" : "Money or percentage",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MSG",
      "display" : "Message type",
      "definition" : "Message type",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "15"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NA",
      "display" : "Numeric array",
      "definition" : "Numeric array",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "65536"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NDL",
      "display" : "Name with date and location",
      "definition" : "Name with date and location",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "835"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NM",
      "display" : "Numeric",
      "definition" : "Numeric",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NR",
      "display" : "Numeric range",
      "definition" : "Numeric range",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "33"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OCD",
      "display" : "Occurrence code and date",
      "definition" : "Occurrence code and date",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "714"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OSD",
      "display" : "Order sequence definition",
      "definition" : "Order sequence definition",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "110"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OSP",
      "display" : "Occurrence span code and date",
      "definition" : "Occurrence span code and date",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "723"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PIP",
      "display" : "Practitioner institutional privileges",
      "definition" : "Practitioner institutional privileges",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "1413"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PL",
      "display" : "Person location",
      "definition" : "Person location",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "1230"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PLN",
      "display" : "Practitioner license or other ID number",
      "definition" : "Practitioner license or other ID number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "101"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PN",
      "display" : "Person name",
      "definition" : "Person name",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PPN",
      "display" : "Performing person time stamp",
      "definition" : "Performing person time stamp",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "2993"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRL",
      "display" : "Parent result link",
      "definition" : "Parent result link",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "755"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PT",
      "display" : "Processing type",
      "definition" : "Processing type",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "3"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PTA",
      "display" : "Policy type and amount",
      "definition" : "Policy type and amount",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "56"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "QIP",
      "display" : "Query input parameter list",
      "definition" : "Query input parameter list",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "212"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "QSC",
      "display" : "Query selection criteria",
      "definition" : "Query selection criteria",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "219"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RCD",
      "display" : "Row column definition",
      "definition" : "Row column definition",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "19"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RFR",
      "display" : "Reference range",
      "definition" : "Reference range",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "352"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RI",
      "display" : "Repeat interval",
      "definition" : "Repeat interval",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "206"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RMC",
      "display" : "Room coverage",
      "definition" : "Room coverage",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "82"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Reference pointer",
      "definition" : "Reference pointer",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "273"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RPT",
      "display" : "Repeat pattern",
      "definition" : "Repeat pattern",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "984"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SAD",
      "display" : "Street Address",
      "definition" : "Street Address",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "184"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SCV",
      "display" : "Scheduling class value pair",
      "definition" : "Scheduling class value pair",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "41"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SI",
      "display" : "Sequence ID",
      "definition" : "Sequence ID",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "4"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SN",
      "display" : "Structured numeric",
      "definition" : "Structured numeric",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "36"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SNM",
      "display" : "String of telephone number digits",
      "definition" : "String of telephone number digits",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SPD",
      "display" : "Specialty description",
      "definition" : "Specialty description",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "112"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SPS",
      "display" : "Specimen source",
      "definition" : "Specimen source",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "4436"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SRT",
      "display" : "Sort order",
      "definition" : "Sort order",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "15"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ST",
      "display" : "String data",
      "definition" : "String data",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "199"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TM",
      "display" : "Time",
      "definition" : "Time",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TN",
      "display" : "Telephone number",
      "definition" : "Telephone number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "199"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TQ",
      "display" : "Timing/quantity",
      "definition" : "Timing/quantity",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "1209"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TS",
      "display" : "Time stamp",
      "definition" : "Time stamp",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "26"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2020-09-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TX",
      "display" : "Text data",
      "definition" : "Text data",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "65536"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UVC",
      "display" : "UB value code and amount",
      "definition" : "UB value code and amount",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "41"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VH",
      "display" : "Visiting hours",
      "definition" : "Visiting hours",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "41"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "VID",
      "display" : "Version identifier",
      "definition" : "Version identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "973"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "VR",
      "display" : "Value range",
      "definition" : "Value range",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WVI",
      "display" : "Channel Identifier",
      "definition" : "Channel Identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "22"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WVS",
      "display" : "Waveform source",
      "definition" : "Waveform source",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "17"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "XAD",
      "display" : "Extended address",
      "definition" : "Extended address",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "631"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "XCN",
      "display" : "Extended composite ID number and name for persons",
      "definition" : "Extended composite ID number and name for persons",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "3002"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "XON",
      "display" : "Extended composite name and ID number for organizations",
      "definition" : "Extended composite name and ID number for organizations",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "567"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "XPN",
      "display" : "Extended person name",
      "definition" : "Extended person name",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "1103"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "XTN",
      "display" : "Extended telecommunications number",
      "definition" : "Extended telecommunications number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "850"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
