# Controlled Substance Schedule (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Controlled Substance Schedule (2.7 - 1.0.0)**

## CodeSystem: Controlled Substance Schedule (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/controlledSubstanceSchedule | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ControlledSubstanceSchedule |
| *Other Identifiers:*OID:2.16.840.1.113883.18.304 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the class of the drug or other substance if its usage is controlled by legislation. In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Other countries should create their own versions of this table. Used in HL7 Version 2.x messaging in the RXE segment. The name of the table is taken from the Pharmacy Law Digest July 1988. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScontrolledSubstanceSchedule](ValueSet-hl7VScontrolledSubstanceSchedule.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "controlledSubstanceSchedule",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0477"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/controlledSubstanceSchedule",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.304"
    }
  ],
  "version" : "1.0.0",
  "name" : "ControlledSubstanceSchedule",
  "title" : "Controlled Substance Schedule (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the class of the drug or other substance if its usage is controlled by legislation.  In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Other countries should create their own versions of this table.  Used in HL7 Version 2.x messaging in the RXE segment.  The name of the table is taken from the Pharmacy Law Digest July 1988.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "I",
      "display" : "Schedule I",
      "definition" : "Schedule I",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Includes drugs that have a high potential for abuse, no currently accepted medical use in the United States and a lack of accepted safety for use under medical supervision."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "II",
      "display" : "Schedule II",
      "definition" : "Schedule II",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Includes drugs having currently accepted medical use in the United States and a high abuse potential, with severe psychological or physical dependence liability."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "III",
      "display" : "Schedule III",
      "definition" : "Schedule III",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Includes drugs having an abuse potential less than that of drugs listed in Schedules I and II. All CS III drugs have a currently accepted medical use in the United States."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "IV",
      "display" : "Schedule IV",
      "definition" : "Schedule IV",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Includes drugs having a lesser potential for abuse than those listed in Schedule III. CS IV drugs have a currently accepted medical use in the United States."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Schedule V",
      "definition" : "Schedule V",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Includes drugs having low abuse potential and limited physical or psychological dependence relative to those listed in IV and have an accepted medical use in the United States."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VI",
      "display" : "Schedule VI",
      "definition" : "Schedule VI",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "State defined"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
