# Amount Type (2.7 - 1.0.0) - HL7 v2.7 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Amount Type (2.7 - 1.0.0)**

## CodeSystem: Amount Type (2.7 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/amountType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AmountType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.67 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in the RMC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSamountType](ValueSet-hl7VSamountType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "amountType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.7"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0146"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/amountType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.67"
    }
  ],
  "version" : "1.0.0",
  "name" : "AmountType",
  "title" : "Amount Type (2.7 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:34:39+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts  which specify amount quantity type.  Used in HL7 Version 2.x messaging in the RMC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "DF",
      "display" : "Differential",
      "definition" : "Differential",
      "designation" : [
        {
          "language" : "de",
          "value" : "Differenzbetrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "LM",
      "display" : "Limit",
      "definition" : "Limit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Höchstbetrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PC",
      "display" : "Percentage",
      "definition" : "Percentage",
      "designation" : [
        {
          "language" : "de",
          "value" : "Prozentsatz"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility only as of v 2.5"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RT",
      "display" : "Rate",
      "definition" : "Rate",
      "designation" : [
        {
          "language" : "de",
          "value" : "Tagessatz"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UL",
      "display" : "Unlimited",
      "definition" : "Unlimited",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbegrenzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
