# Time Selection Criteria Parameter Class Codes (2.6 - 1.1.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Time Selection Criteria Parameter Class Codes (2.6 - 1.1.0)**

## CodeSystem: Time Selection Criteria Parameter Class Codes (2.6 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/timeSelectionCriteriaParameterClass | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:TimeSelectionCriteriaParameterClass |
| *Other Identifiers:*OID:2.16.840.1.113883.18.183 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. Used in HL7 Version 2.x messaging in the SCV and APR segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStimeSelectionCriteriaParameterClassCodes](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "timeSelectionCriteriaParameterClass",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0294"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/timeSelectionCriteriaParameterClass",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.183"
    }
  ],
  "version" : "1.1.0",
  "name" : "TimeSelectionCriteriaParameterClass",
  "title" : "Time Selection Criteria Parameter Class Codes (2.6 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling.  Used in HL7 Version 2.x messaging in the SCV and APR segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : false,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "Fri",
      "display" : "An indicator that Friday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Friday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Mon",
      "display" : "An indicator that Monday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Monday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Prefend",
      "display" : "An indicator that there is a preferred end time for the appointment request, service or resource.",
      "definition" : "An indicator that there is a preferred end time for the appointment request, service or resource.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Prefstart",
      "display" : "An indicator that there is a preferred start time for the appointment request, service or resource.",
      "definition" : "An indicator that there is a preferred start time for the appointment request, service or resource.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Sat",
      "display" : "An indicator that Saturday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Saturday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Sun",
      "display" : "An indicator that Sunday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Sunday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Thu",
      "display" : "An indicator that Thursday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Thursday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Tue",
      "display" : "An indicator that Tuesday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Tuesday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Wed",
      "display" : "An indicator that Wednesday is or is not preferred for the day on which the appointment will occur.",
      "definition" : "An indicator that Wednesday is or is not preferred for the day on which the appointment will occur.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
