# Substance Type (2.6 - 1.0.1) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance Type (2.6 - 1.0.1)**

## CodeSystem: Substance Type (2.6 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/substanceType | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:SubstanceType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.237 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts identifying the type of substance. Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsubstanceType](ValueSet-hl7VSsubstanceType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "substanceType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0384"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/substanceType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.237"
    }
  ],
  "version" : "1.0.1",
  "name" : "SubstanceType",
  "title" : "Substance Type (2.6 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined  code system of concepts identifying the type of substance.  Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CO",
      "display" : "Control",
      "definition" : "Control",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "Diluent",
      "definition" : "Diluent",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Measurable Liquid Item",
      "definition" : "Measurable Liquid Item",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LW",
      "display" : "Liquid Waste",
      "definition" : "Liquid Waste",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MR",
      "display" : "Multiple Test Reagent",
      "definition" : "Multiple Test Reagent",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OT",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PT",
      "display" : "Pretreatment",
      "definition" : "Pretreatment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PW",
      "display" : "Purified Water",
      "definition" : "Purified Water",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RC",
      "display" : "Reagent Calibrator",
      "definition" : "Reagent Calibrator",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "Countable Solid Item",
      "definition" : "Countable Solid Item",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SR",
      "display" : "Single Test Reagent",
      "definition" : "Single Test Reagent",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SW",
      "display" : "Solid Waste",
      "definition" : "Solid Waste",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
