# Specialty Type (2.6 - 1.0.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specialty Type (2.6 - 1.0.0)**

## CodeSystem: Specialty Type (2.6 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specialtyType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:SpecialtyType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.159 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition. Used in HL7 Version 2.x messaging in the LDP segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSspecialtyType](ValueSet-hl7VSspecialtyType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specialtyType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0265"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specialtyType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.159"
    }
  ],
  "version" : "1.0.0",
  "name" : "SpecialtyType",
  "title" : "Specialty Type (2.6 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition.  Used in HL7 Version 2.x messaging in the LDP segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ALC",
      "display" : "Allergy",
      "definition" : "Allergy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AMB",
      "display" : "Ambulatory",
      "definition" : "Ambulatory",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CAN",
      "display" : "Cancer",
      "definition" : "Cancer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CAR",
      "display" : "Coronary/cardiac care",
      "definition" : "Coronary/cardiac care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CCR",
      "display" : "Critical care",
      "definition" : "Critical care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CHI",
      "display" : "Chiropractic",
      "definition" : "Chiropractic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EDI",
      "display" : "Education",
      "definition" : "Education",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EMR",
      "display" : "Emergency",
      "definition" : "Emergency",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FPC",
      "display" : "Family planning",
      "definition" : "Family planning",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "INT",
      "display" : "Intensive care",
      "definition" : "Intensive care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ISO",
      "display" : "Isolation",
      "definition" : "Isolation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NAT",
      "display" : "Naturopathic",
      "definition" : "Naturopathic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NBI",
      "display" : "Newborn, nursery, infants",
      "definition" : "Newborn, nursery, infants",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OBG",
      "display" : "Obstetrics, gynecology",
      "definition" : "Obstetrics, gynecology",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OBS",
      "display" : "Observation",
      "definition" : "Observation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "Other specialty",
      "definition" : "Other specialty",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PED",
      "display" : "Pediatrics",
      "definition" : "Pediatrics",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PHY",
      "display" : "General/family practice",
      "definition" : "General/family practice",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PIN",
      "display" : "Pediatric/neonatal intensive care",
      "definition" : "Pediatric/neonatal intensive care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PPS",
      "display" : "Pediatric psychiatric",
      "definition" : "Pediatric psychiatric",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PRE",
      "display" : "Pediatric rehabilitation",
      "definition" : "Pediatric rehabilitation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PSI",
      "display" : "Psychiatric intensive care",
      "definition" : "Psychiatric intensive care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PSY",
      "display" : "Psychiatric",
      "definition" : "Psychiatric",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "REH",
      "display" : "Rehabilitation",
      "definition" : "Rehabilitation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SUR",
      "display" : "Surgery",
      "definition" : "Surgery",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "WIC",
      "display" : "Walk-in clinic",
      "definition" : "Walk-in clinic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
