# Override Type (2.6 - 1.0.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Override Type (2.6 - 1.0.0)**

## CodeSystem: Override Type (2.6 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/overrideType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:OverrideType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.339 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify what type of override can be used to override the specific error identified. Used in HL7 Version 2 messaging in the ERR and OVR segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSoverrideType](ValueSet-hl7VSoverrideType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "overrideType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0518"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/overrideType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.339"
    }
  ],
  "version" : "1.0.0",
  "name" : "OverrideType",
  "title" : "Override Type (2.6 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify what type of override can be used to override the specific error identified.   Used in HL7 Version 2 messaging in the ERR and OVR segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "EQV",
      "display" : "Equivalence Override",
      "definition" : "Equivalence Override",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EXTN",
      "display" : "Extension Override",
      "definition" : "Extension Override",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INLV",
      "display" : "Interval Override",
      "definition" : "Interval Override",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
