# Master File Identifier Code (2.6 - 1.2.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Master File Identifier Code (2.6 - 1.2.0)**

## CodeSystem: Master File Identifier Code (2.6 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/masterFileIdentifierCodes | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:MasterFileIdentifierCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.460 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files. Used in HL7 Version 2.x messaging in the MFI segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmasterFileIdentifierCode](ValueSet-hl7VSmasterFileIdentifierCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "masterFileIdentifierCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0175"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/masterFileIdentifierCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.460"
    }
  ],
  "version" : "1.2.0",
  "name" : "MasterFileIdentifierCodes",
  "title" : "Master File Identifier Code (2.6 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files.  Used in HL7 Version 2.x messaging in the MFI segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CDM",
      "display" : "Charge description master file",
      "definition" : "Charge description master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Leistungskatalog"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "CLN",
      "display" : "Clinic master file",
      "definition" : "Clinic master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Klinikkatalog"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CMA",
      "display" : "Clinical study with phases and scheduled master file",
      "definition" : "Clinical study with phases and scheduled master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CMB",
      "display" : "Clinical study without phases but with scheduled master file",
      "definition" : "Clinical study without phases but with scheduled master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "INV",
      "display" : "Inventory master file",
      "definition" : "Inventory master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LOC",
      "display" : "Location master file",
      "definition" : "Location master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OMA",
      "display" : "Numerical observation master file",
      "definition" : "Numerical observation master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OMB",
      "display" : "Categorical observation master file",
      "definition" : "Categorical observation master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OMC",
      "display" : "Observation batteries master file",
      "definition" : "Observation batteries master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OMD",
      "display" : "Calculated observations master file",
      "definition" : "Calculated observations master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OME",
      "display" : "Other Observation/Service Item master file",
      "definition" : "Other Observation/Service Item master file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRA",
      "display" : "Practitioner master file",
      "definition" : "Practitioner master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ärztekatalog"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "STF",
      "display" : "Staff master file",
      "definition" : "Staff master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Mitarbeiterkatalog"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
