# Body Parts (2.6 - 1.0.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Body Parts (2.6 - 1.0.0)**

## CodeSystem: Body Parts (2.6 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/bodyParts | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:BodyParts |
| *Other Identifiers:*OID:2.16.840.1.113883.18.356 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the part of the body. Used in HL7 Version 2 messaging in the RXR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSbodyParts](ValueSet-hl7VSbodyParts.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "bodyParts",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0550"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/bodyParts",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.356"
    }
  ],
  "version" : "1.0.0",
  "name" : "BodyParts",
  "title" : "Body Parts (2.6 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the part of the body.  Used in HL7 Version 2 messaging in the RXR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ACET",
      "display" : "Acetabulum",
      "definition" : "Acetabulum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ACHIL",
      "display" : "Achilles",
      "definition" : "Achilles",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ADB",
      "display" : "Abdomen",
      "definition" : "Abdomen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ADE",
      "display" : "Adenoids",
      "definition" : "Adenoids",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ADR",
      "display" : "Adrenal",
      "definition" : "Adrenal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AMN",
      "display" : "Amniotic fluid",
      "definition" : "Amniotic fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AMS",
      "display" : "Amniotic Sac",
      "definition" : "Amniotic Sac",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANAL",
      "display" : "Anal",
      "definition" : "Anal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANKL",
      "display" : "Ankle",
      "definition" : "Ankle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANTEC",
      "display" : "Antecubital",
      "definition" : "Antecubital",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANTECF",
      "display" : "Antecubital Fossa",
      "definition" : "Antecubital Fossa",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANTR",
      "display" : "Antrum",
      "definition" : "Antrum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANUS",
      "display" : "Anus",
      "definition" : "Anus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AORTA",
      "display" : "Aorta",
      "definition" : "Aorta",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "APDX",
      "display" : "Appendix",
      "definition" : "Appendix",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Aortic Rim",
      "definition" : "Aortic Rim",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AREO",
      "display" : "Areola",
      "definition" : "Areola",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ARM",
      "display" : "Arm",
      "definition" : "Arm",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ARTE",
      "display" : "Artery",
      "definition" : "Artery",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ASCIT",
      "display" : "Ascites",
      "definition" : "Ascites",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ASCT",
      "display" : "Ascitic Fluid",
      "definition" : "Ascitic Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ATR",
      "display" : "Atrium",
      "definition" : "Atrium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AURI",
      "display" : "Auricular",
      "definition" : "Auricular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AV",
      "display" : "Aortic Valve",
      "definition" : "Aortic Valve",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AXI",
      "display" : "Axilla",
      "definition" : "Axilla",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BACK",
      "display" : "Back",
      "definition" : "Back",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BARTD",
      "display" : "Bartholin Duct",
      "definition" : "Bartholin Duct",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BARTG",
      "display" : "Bartholin Gland",
      "definition" : "Bartholin Gland",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BCYS",
      "display" : "Brain Cyst Fluid",
      "definition" : "Brain Cyst Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BDY",
      "display" : "Body, Whole",
      "definition" : "Body, Whole",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BID",
      "display" : "Bile Duct",
      "definition" : "Bile Duct",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BIFL",
      "display" : "Bile fluid",
      "definition" : "Bile fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BLAD",
      "display" : "Bladder",
      "definition" : "Bladder",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BLD",
      "display" : "Blood, Whole",
      "definition" : "Blood, Whole",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BLDA",
      "display" : "Blood,  Arterial",
      "definition" : "Blood,  Arterial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BLDC",
      "display" : "Blood,  Capillary",
      "definition" : "Blood,  Capillary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BLDV",
      "display" : "Blood,  Venous",
      "definition" : "Blood,  Venous",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BLOOD",
      "display" : "Blood",
      "definition" : "Blood",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BMAR",
      "display" : "Bone marrow",
      "definition" : "Bone marrow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BON",
      "display" : "Bone",
      "definition" : "Bone",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BOWEL",
      "display" : "Bowel",
      "definition" : "Bowel",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BOWLA",
      "display" : "Bowel, Large",
      "definition" : "Bowel, Large",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BOWSM",
      "display" : "Bowel, Small",
      "definition" : "Bowel, Small",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BPH",
      "display" : "Basophils",
      "definition" : "Basophils",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRA",
      "display" : "Brachial",
      "definition" : "Brachial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRAIN",
      "display" : "Brain",
      "definition" : "Brain",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRO",
      "display" : "Bronchial",
      "definition" : "Bronchial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BROCH",
      "display" : "Bronchiole/Bronchiolar",
      "definition" : "Bronchiole/Bronchiolar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRONC",
      "display" : "Bronchus/Bronchial",
      "definition" : "Bronchus/Bronchial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BROW",
      "display" : "Eyebrow",
      "definition" : "Eyebrow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRST",
      "display" : "Breast",
      "definition" : "Breast",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRSTFL",
      "display" : "Breast fluid",
      "definition" : "Breast fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRTGF",
      "display" : "Bartholin Gland Fluid",
      "definition" : "Bartholin Gland Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BRV",
      "display" : "Broviac",
      "definition" : "Broviac",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BUCCA",
      "display" : "Buccal",
      "definition" : "Buccal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BURSA",
      "display" : "Bursa",
      "definition" : "Bursa",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BURSF",
      "display" : "Bursa Fluid",
      "definition" : "Bursa Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BUTT",
      "display" : "Buttocks",
      "definition" : "Buttocks",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CALF",
      "display" : "Calf",
      "definition" : "Calf",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CANAL",
      "display" : "Canal",
      "definition" : "Canal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CANLI",
      "display" : "Canaliculis",
      "definition" : "Canaliculis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CANTH",
      "display" : "Canthus",
      "definition" : "Canthus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CARO",
      "display" : "Carotid",
      "definition" : "Carotid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CARP",
      "display" : "Carpal",
      "definition" : "Carpal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CAVIT",
      "display" : "Cavity",
      "definition" : "Cavity",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CBLD",
      "display" : "Blood, Cord",
      "definition" : "Blood, Cord",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CDM",
      "display" : "Cardiac Muscle",
      "definition" : "Cardiac Muscle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CDUCT",
      "display" : "Common Duct",
      "definition" : "Common Duct",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CECUM",
      "display" : "Cecum/Cecal",
      "definition" : "Cecum/Cecal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CERVUT",
      "display" : "Cervix/Uterus",
      "definition" : "Cervix/Uterus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CHE",
      "display" : "Cavity, Chest",
      "definition" : "Cavity, Chest",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CHEEK",
      "display" : "Cheek",
      "definition" : "Cheek",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CHES",
      "display" : "Chest",
      "definition" : "Chest",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CHEST",
      "display" : "Chest Tube",
      "definition" : "Chest Tube",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CHIN",
      "display" : "Chin",
      "definition" : "Chin",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CIRCU",
      "display" : "Circumcision Site",
      "definition" : "Circumcision Site",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CLAVI",
      "display" : "Clavicle/Clavicular",
      "definition" : "Clavicle/Clavicular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CLIT",
      "display" : "Clitoris",
      "definition" : "Clitoris",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CLITO",
      "display" : "Clitoral",
      "definition" : "Clitoral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CNL",
      "display" : "Cannula",
      "definition" : "Cannula",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COCCG",
      "display" : "Coccygeal",
      "definition" : "Coccygeal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COCCY",
      "display" : "Coccyx",
      "definition" : "Coccyx",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COLON",
      "display" : "Colon",
      "definition" : "Colon",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COLOS",
      "display" : "Colostomy",
      "definition" : "Colostomy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CONJ",
      "display" : "Conjunctiva",
      "definition" : "Conjunctiva",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COR",
      "display" : "Cord",
      "definition" : "Cord",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CORAL",
      "display" : "Coral",
      "definition" : "Coral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CORD",
      "display" : "Cord Blood",
      "definition" : "Cord Blood",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CORN",
      "display" : "Cornea",
      "definition" : "Cornea",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COS",
      "display" : "Colostomy Stoma",
      "definition" : "Colostomy Stoma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CRANE",
      "display" : "Cranium, ethmoid",
      "definition" : "Cranium, ethmoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CRANF",
      "display" : "Cranium, frontal",
      "definition" : "Cranium, frontal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CRANO",
      "display" : "Cranium, occipital",
      "definition" : "Cranium, occipital",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CRANP",
      "display" : "Cranium, parietal",
      "definition" : "Cranium, parietal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CRANS",
      "display" : "Cranium, sphenoid",
      "definition" : "Cranium, sphenoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CRANT",
      "display" : "Cranium, temporal",
      "definition" : "Cranium, temporal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CSF",
      "display" : "Cerebral Spinal Fluid",
      "definition" : "Cerebral Spinal Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CUBIT",
      "display" : "Cubitus",
      "definition" : "Cubitus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CUFF",
      "display" : "Cuff",
      "definition" : "Cuff",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CULD",
      "display" : "Cul De Sac",
      "definition" : "Cul De Sac",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CULDO",
      "display" : "Culdocentesis",
      "definition" : "Culdocentesis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CVX",
      "display" : "Cervix",
      "definition" : "Cervix",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DELT",
      "display" : "Deltoid",
      "definition" : "Deltoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DEN",
      "display" : "Dental Gingiva",
      "definition" : "Dental Gingiva",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DENTA",
      "display" : "Dental",
      "definition" : "Dental",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DIAF",
      "display" : "Dialysis Fluid",
      "definition" : "Dialysis Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DIGIT",
      "display" : "Digit",
      "definition" : "Digit",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DISC",
      "display" : "Disc",
      "definition" : "Disc",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DORS",
      "display" : "Dorsum/Dorsal",
      "definition" : "Dorsum/Dorsal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DPH",
      "display" : "Diaphragm",
      "definition" : "Diaphragm",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DUFL",
      "display" : "Duodenal Fluid",
      "definition" : "Duodenal Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DUODE",
      "display" : "Duodenum/Duodenal",
      "definition" : "Duodenum/Duodenal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DUR",
      "display" : "Dura",
      "definition" : "Dura",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EAR",
      "display" : "Ear",
      "definition" : "Ear",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EARBI",
      "display" : "Ear bone, incus",
      "definition" : "Ear bone, incus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EARBM",
      "display" : "Ear bone, malleus",
      "definition" : "Ear bone, malleus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EARBS",
      "display" : "Ear bone,stapes",
      "definition" : "Ear bone,stapes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EARLO",
      "display" : "Ear Lobe",
      "definition" : "Ear Lobe",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EC",
      "display" : "Endocervical",
      "definition" : "Endocervical",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ELBOW",
      "display" : "Elbow",
      "definition" : "Elbow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ELBOWJ",
      "display" : "Elbow Joint",
      "definition" : "Elbow Joint",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ENDC",
      "display" : "Endocardium",
      "definition" : "Endocardium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ENDM",
      "display" : "Endometrium",
      "definition" : "Endometrium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EOLPH",
      "display" : "endolpthamitis",
      "definition" : "endolpthamitis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EOS",
      "display" : "Eosinophils",
      "definition" : "Eosinophils",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EPD",
      "display" : "Epididymis",
      "definition" : "Epididymis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EPICA",
      "display" : "Epicardial",
      "definition" : "Epicardial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EPICM",
      "display" : "Epicardium",
      "definition" : "Epicardium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EPIDU",
      "display" : "Epidural",
      "definition" : "Epidural",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EPIGL",
      "display" : "Epiglottis",
      "definition" : "Epiglottis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ESO",
      "display" : "Esophagus",
      "definition" : "Esophagus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ESOPG",
      "display" : "Esophageal",
      "definition" : "Esophageal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ET",
      "display" : "Endotracheal",
      "definition" : "Endotracheal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ETHMO",
      "display" : "Ethmoid",
      "definition" : "Ethmoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EUR",
      "display" : "Endourethral",
      "definition" : "Endourethral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EYE",
      "display" : "Eye",
      "definition" : "Eye",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EYELI",
      "display" : "Eyelid",
      "definition" : "Eyelid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FACE",
      "display" : "Face",
      "definition" : "Face",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FALLT",
      "display" : "Fallopian Tube",
      "definition" : "Fallopian Tube",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBINC",
      "display" : "Facial bone, inferior nasal concha",
      "definition" : "Facial bone, inferior nasal concha",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBLAC",
      "display" : "Facial bone, lacrimal",
      "definition" : "Facial bone, lacrimal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBMAX",
      "display" : "Facial bone, maxilla",
      "definition" : "Facial bone, maxilla",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBNAS",
      "display" : "Facial bone, nasal",
      "definition" : "Facial bone, nasal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBPAL",
      "display" : "Facial bone, palatine",
      "definition" : "Facial bone, palatine",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBVOM",
      "display" : "Facial bone, vomer",
      "definition" : "Facial bone, vomer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FBZYG",
      "display" : "Facial bone, zygomatic",
      "definition" : "Facial bone, zygomatic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FEMOR",
      "display" : "Femoral",
      "definition" : "Femoral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FEMUR",
      "display" : "Femur",
      "definition" : "Femur",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FET",
      "display" : "Fetus",
      "definition" : "Fetus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FIBU",
      "display" : "Fibula",
      "definition" : "Fibula",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FING",
      "display" : "Finger",
      "definition" : "Finger",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FINGN",
      "display" : "Finger Nail",
      "definition" : "Finger Nail",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FMH",
      "display" : "Femoral Head",
      "definition" : "Femoral Head",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FOL",
      "display" : "Follicle",
      "definition" : "Follicle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FOOT",
      "display" : "Foot",
      "definition" : "Foot",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FOREA",
      "display" : "Forearm",
      "definition" : "Forearm",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FOREH",
      "display" : "Forehead",
      "definition" : "Forehead",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FORES",
      "display" : "Foreskin",
      "definition" : "Foreskin",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FOURC",
      "display" : "Fourchette",
      "definition" : "Fourchette",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GB",
      "display" : "Gall Bladder",
      "definition" : "Gall Bladder",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GEN",
      "display" : "Genital",
      "definition" : "Genital",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GENC",
      "display" : "Genital Cervix",
      "definition" : "Genital Cervix",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GENL",
      "display" : "Genital Lochia",
      "definition" : "Genital Lochia",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GL",
      "display" : "Genital Lesion",
      "definition" : "Genital Lesion",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GLAND",
      "display" : "Gland",
      "definition" : "Gland",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GLANS",
      "display" : "Glans",
      "definition" : "Glans",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GLUT",
      "display" : "Gluteus",
      "definition" : "Gluteus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GLUTE",
      "display" : "Gluteal",
      "definition" : "Gluteal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GLUTM",
      "display" : "Gluteus Medius",
      "definition" : "Gluteus Medius",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GROIN",
      "display" : "Groin",
      "definition" : "Groin",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GUM",
      "display" : "Gum",
      "definition" : "Gum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GVU",
      "display" : "Genital - Vulva",
      "definition" : "Genital - Vulva",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HAL",
      "display" : "Hallux",
      "definition" : "Hallux",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HAND",
      "display" : "Hand",
      "definition" : "Hand",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HAR",
      "display" : "Hair",
      "definition" : "Hair",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HART",
      "display" : "Heart",
      "definition" : "Heart",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HEAD",
      "display" : "Head",
      "definition" : "Head",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HEEL",
      "display" : "Heel",
      "definition" : "Heel",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HEM",
      "display" : "Hemorrhoid",
      "definition" : "Hemorrhoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HIP",
      "display" : "Hip",
      "definition" : "Hip",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HIPJ",
      "display" : "Hip Joint",
      "definition" : "Hip Joint",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HUMER",
      "display" : "Humerus",
      "definition" : "Humerus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HV",
      "display" : "Heart Valve",
      "definition" : "Heart Valve",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HVB",
      "display" : "Heart Valve, Bicuspid",
      "definition" : "Heart Valve, Bicuspid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HVT",
      "display" : "Heart Valve, Tricuspid",
      "definition" : "Heart Valve, Tricuspid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HYMEN",
      "display" : "Hymen",
      "definition" : "Hymen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ICX",
      "display" : "Intracervical",
      "definition" : "Intracervical",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILC",
      "display" : "Ileal Conduit",
      "definition" : "Ileal Conduit",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILCON",
      "display" : "Ilical Conduit",
      "definition" : "Ilical Conduit",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILCR",
      "display" : "Iliac Crest",
      "definition" : "Iliac Crest",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILE",
      "display" : "Ileal Loop",
      "definition" : "Ileal Loop",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILEOS",
      "display" : "Ileostomy",
      "definition" : "Ileostomy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILEUM",
      "display" : "Ileum",
      "definition" : "Ileum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ILIAC",
      "display" : "Iliac",
      "definition" : "Iliac",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INASA",
      "display" : "Intranasal",
      "definition" : "Intranasal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INGUI",
      "display" : "Inguinal",
      "definition" : "Inguinal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INSTL",
      "display" : "Intestine, Large",
      "definition" : "Intestine, Large",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INSTS",
      "display" : "Intestine, Small",
      "definition" : "Intestine, Small",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INT",
      "display" : "Intestine",
      "definition" : "Intestine",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INTRO",
      "display" : "Introitus",
      "definition" : "Introitus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INTRU",
      "display" : "Intrauterine",
      "definition" : "Intrauterine",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ISCHI",
      "display" : "Ischium",
      "definition" : "Ischium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ISH",
      "display" : "Loop, Ishial",
      "definition" : "Loop, Ishial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "JAW",
      "display" : "Jaw",
      "definition" : "Jaw",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "JUGE",
      "display" : "Jugular, External",
      "definition" : "Jugular, External",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-06-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "JUGI",
      "display" : "Jugular, Internal",
      "definition" : "Jugular, Internal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "KIDN",
      "display" : "Kidney",
      "definition" : "Kidney",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "KNEE",
      "display" : "Knee",
      "definition" : "Knee",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "KNEEF",
      "display" : "Knee Fluid",
      "definition" : "Knee Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "KNEEJ",
      "display" : "Knee Joint",
      "definition" : "Knee Joint",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LABIA",
      "display" : "Labia",
      "definition" : "Labia",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LABMA",
      "display" : "Labia Majora",
      "definition" : "Labia Majora",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LABMI",
      "display" : "Labia Minora",
      "definition" : "Labia Minora",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LACRI",
      "display" : "Lacrimal",
      "definition" : "Lacrimal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LAM",
      "display" : "Lamella",
      "definition" : "Lamella",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LARYN",
      "display" : "Larynx",
      "definition" : "Larynx",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LEG",
      "display" : "Leg",
      "definition" : "Leg",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LENS",
      "display" : "Lens",
      "definition" : "Lens",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LING",
      "display" : "Lingual",
      "definition" : "Lingual",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LINGU",
      "display" : "Lingula",
      "definition" : "Lingula",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LIP",
      "display" : "Lip",
      "definition" : "Lip",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LIVER",
      "display" : "Liver",
      "definition" : "Liver",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LMN",
      "display" : "Lumen",
      "definition" : "Lumen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LN",
      "display" : "Lymph Node",
      "definition" : "Lymph Node",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LNG",
      "display" : "Lymph Node, Groin",
      "definition" : "Lymph Node, Groin",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LOBE",
      "display" : "Lobe",
      "definition" : "Lobe",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LOCH",
      "display" : "Lochia",
      "definition" : "Lochia",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LUMBA",
      "display" : "Lumbar",
      "definition" : "Lumbar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LUNG",
      "display" : "Lung",
      "definition" : "Lung",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LYM",
      "display" : "Lymphocytes",
      "definition" : "Lymphocytes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MAC",
      "display" : "Macrophages",
      "definition" : "Macrophages",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MALLE",
      "display" : "Malleolus",
      "definition" : "Malleolus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MANDI",
      "display" : "Mandible/Mandibular",
      "definition" : "Mandible/Mandibular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MAR",
      "display" : "Marrow",
      "definition" : "Marrow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MAST",
      "display" : "Mastoid",
      "definition" : "Mastoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MAXIL",
      "display" : "Maxilla/Maxillary",
      "definition" : "Maxilla/Maxillary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MAXS",
      "display" : "Maxillary Sinus",
      "definition" : "Maxillary Sinus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MEATU",
      "display" : "Meatus",
      "definition" : "Meatus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MEC",
      "display" : "Meconium",
      "definition" : "Meconium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MEDST",
      "display" : "Mediastinum",
      "definition" : "Mediastinum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MEDU",
      "display" : "Medullary",
      "definition" : "Medullary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "METAC",
      "display" : "Metacarpal",
      "definition" : "Metacarpal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "METAT",
      "display" : "Metatarsal",
      "definition" : "Metatarsal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MILK",
      "display" : "Milk, Breast",
      "definition" : "Milk, Breast",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MITRL",
      "display" : "Mitral Valve",
      "definition" : "Mitral Valve",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MOLAR",
      "display" : "Molar",
      "definition" : "Molar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MONSU",
      "display" : "Mons Ureteris",
      "definition" : "Mons Ureteris",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MONSV",
      "display" : "Mons Veneris(Mons Pubis)",
      "definition" : "Mons Veneris(Mons Pubis)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MOU",
      "display" : "Membrane",
      "definition" : "Membrane",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MOUTH",
      "display" : "Mouth",
      "definition" : "Mouth",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MP",
      "display" : "Mons Pubis",
      "definition" : "Mons Pubis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MPB",
      "display" : "Meninges",
      "definition" : "Meninges",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MRSA2",
      "display" : "Mrsa:",
      "definition" : "Mrsa:",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MYO",
      "display" : "Myocardium",
      "definition" : "Myocardium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NAIL",
      "display" : "Nail",
      "definition" : "Nail",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NAILB",
      "display" : "Nail Bed",
      "definition" : "Nail Bed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NAILF",
      "display" : "Nail, Finger",
      "definition" : "Nail, Finger",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NAILT",
      "display" : "Nail, Toe",
      "definition" : "Nail, Toe",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NARES",
      "display" : "Nares",
      "definition" : "Nares",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NASL",
      "display" : "Nasal",
      "definition" : "Nasal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NAVEL",
      "display" : "Navel",
      "definition" : "Navel",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NECK",
      "display" : "Neck",
      "definition" : "Neck",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NERVE",
      "display" : "Nerve",
      "definition" : "Nerve",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NIPPL",
      "display" : "Nipple",
      "definition" : "Nipple",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NLACR",
      "display" : "Nasolacrimal",
      "definition" : "Nasolacrimal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NOS",
      "display" : "Nose (Nasal Passage)",
      "definition" : "Nose (Nasal Passage)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NOSE",
      "display" : "Nose/Nose(outside)",
      "definition" : "Nose/Nose(outside)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NOSTR",
      "display" : "Nostril",
      "definition" : "Nostril",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NP",
      "display" : "Nasopharyngeal",
      "definition" : "Nasopharyngeal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NSS",
      "display" : "Nasal Septum",
      "definition" : "Nasal Septum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NTRAC",
      "display" : "Nasotracheal",
      "definition" : "Nasotracheal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OCCIP",
      "display" : "Occipital",
      "definition" : "Occipital",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OLECR",
      "display" : "Olecranon",
      "definition" : "Olecranon",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OMEN",
      "display" : "Omentum",
      "definition" : "Omentum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ORBIT",
      "display" : "Orbit/Orbital",
      "definition" : "Orbit/Orbital",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ORO",
      "display" : "Oropharynx",
      "definition" : "Oropharynx",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OSCOX",
      "display" : "Os coxa (pelvic girdle)",
      "definition" : "Os coxa (pelvic girdle)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OVARY",
      "display" : "Ovary",
      "definition" : "Ovary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PAFL",
      "display" : "Pancreatic Fluid",
      "definition" : "Pancreatic Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PALAT",
      "display" : "Palate",
      "definition" : "Palate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PALM",
      "display" : "Palm",
      "definition" : "Palm",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PANAL",
      "display" : "Perianal/Perirectal",
      "definition" : "Perianal/Perirectal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PANCR",
      "display" : "Pancreas",
      "definition" : "Pancreas",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PARAT",
      "display" : "Paratracheal",
      "definition" : "Paratracheal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PARIE",
      "display" : "Parietal",
      "definition" : "Parietal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PARON",
      "display" : "Paronychia",
      "definition" : "Paronychia",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PAROT",
      "display" : "Parotid",
      "definition" : "Parotid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PAS",
      "display" : "Parasternal",
      "definition" : "Parasternal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PATEL",
      "display" : "Patella",
      "definition" : "Patella",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PCARD",
      "display" : "Pericardium",
      "definition" : "Pericardium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PCLIT",
      "display" : "Periclitoral",
      "definition" : "Periclitoral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PELV",
      "display" : "Pelvis",
      "definition" : "Pelvis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PENIS",
      "display" : "Penis",
      "definition" : "Penis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PENSH",
      "display" : "Penile Shaft",
      "definition" : "Penile Shaft",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PER",
      "display" : "Peritoneal",
      "definition" : "Peritoneal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERI",
      "display" : "Pericardial Fluid",
      "definition" : "Pericardial Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERIH",
      "display" : "Perihepatic",
      "definition" : "Perihepatic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERIN",
      "display" : "Perineal Abscess",
      "definition" : "Perineal Abscess",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERIS",
      "display" : "Perisplenic",
      "definition" : "Perisplenic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERIT",
      "display" : "Peritoneum",
      "definition" : "Peritoneum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERIU",
      "display" : "Periurethal",
      "definition" : "Periurethal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERIV",
      "display" : "Perivesicular",
      "definition" : "Perivesicular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERRA",
      "display" : "Perirectal",
      "definition" : "Perirectal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PERT",
      "display" : "Peritoneal Fluid",
      "definition" : "Peritoneal Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PHALA",
      "display" : "Phalanyx",
      "definition" : "Phalanyx",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PILO",
      "display" : "Pilonidal",
      "definition" : "Pilonidal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PINNA",
      "display" : "Pinna",
      "definition" : "Pinna",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLACF",
      "display" : "Placenta (Fetal Side)",
      "definition" : "Placenta (Fetal Side)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLACM",
      "display" : "Placenta (Maternal Side)",
      "definition" : "Placenta (Maternal Side)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLANT",
      "display" : "Plantar",
      "definition" : "Plantar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLATH",
      "display" : "Palate, Hard",
      "definition" : "Palate, Hard",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLATS",
      "display" : "Palate, Soft",
      "definition" : "Palate, Soft",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLC",
      "display" : "Placenta",
      "definition" : "Placenta",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLEU",
      "display" : "Pleural Fluid",
      "definition" : "Pleural Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLEUR",
      "display" : "Pleura",
      "definition" : "Pleura",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PLR",
      "display" : "Pleural Fluid (Thoracentesis Fld)",
      "definition" : "Pleural Fluid (Thoracentesis Fld)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PNEAL",
      "display" : "Perineal",
      "definition" : "Perineal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PNEPH",
      "display" : "Perinephric",
      "definition" : "Perinephric",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PNM",
      "display" : "Perineum",
      "definition" : "Perineum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "POPLI",
      "display" : "Popliteal",
      "definition" : "Popliteal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PORBI",
      "display" : "Periorbital",
      "definition" : "Periorbital",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PREAU",
      "display" : "Preauricular",
      "definition" : "Preauricular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRERE",
      "display" : "Prerenal",
      "definition" : "Prerenal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PROS",
      "display" : "Prostatic Fluid",
      "definition" : "Prostatic Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRST",
      "display" : "Prostate Gland",
      "definition" : "Prostate Gland",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PTONS",
      "display" : "Peritonsillar",
      "definition" : "Peritonsillar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PUBIC",
      "display" : "Pubic",
      "definition" : "Pubic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PUL",
      "display" : "Pulmonary Artery",
      "definition" : "Pulmonary Artery",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RADI",
      "display" : "Radial",
      "definition" : "Radial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RADIUS",
      "display" : "Radius",
      "definition" : "Radius",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RBC",
      "display" : "Red Blood Cells",
      "definition" : "Red Blood Cells",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RECTL",
      "display" : "Rectal",
      "definition" : "Rectal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RECTU",
      "display" : "Rectum",
      "definition" : "Rectum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RENL",
      "display" : "Renal",
      "definition" : "Renal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RIB",
      "display" : "Rib",
      "definition" : "Rib",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RNP",
      "display" : "Renal Pelvis",
      "definition" : "Renal Pelvis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RPERI",
      "display" : "Retroperitoneal",
      "definition" : "Retroperitoneal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SAC",
      "display" : "Uterine Cul/De/Sac",
      "definition" : "Uterine Cul/De/Sac",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SACIL",
      "display" : "Sacroiliac",
      "definition" : "Sacroiliac",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SACRA",
      "display" : "Sacral",
      "definition" : "Sacral",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SACRO",
      "display" : "Sacrococcygeal",
      "definition" : "Sacrococcygeal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SACRU",
      "display" : "Sacrum",
      "definition" : "Sacrum",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SALGL",
      "display" : "Salivary Gland",
      "definition" : "Salivary Gland",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCALP",
      "display" : "Scalp",
      "definition" : "Scalp",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCAPU",
      "display" : "Scapula/Scapular",
      "definition" : "Scapula/Scapular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCLAV",
      "display" : "Supraclavicle/Supraclavicular",
      "definition" : "Supraclavicle/Supraclavicular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCLER",
      "display" : "Sclera",
      "definition" : "Sclera",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCLV",
      "display" : "Sub Clavian",
      "definition" : "Sub Clavian",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCROT",
      "display" : "Scrotum/Scrotal",
      "definition" : "Scrotum/Scrotal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SDP",
      "display" : "Subdiaphramatic",
      "definition" : "Subdiaphramatic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SEM",
      "display" : "Seminal Fluid",
      "definition" : "Seminal Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SEMN",
      "display" : "Semen",
      "definition" : "Semen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SEPTU",
      "display" : "Septum/Septal",
      "definition" : "Septum/Septal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SEROM",
      "display" : "Seroma",
      "definition" : "Seroma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SGF",
      "display" : "Subgaleal Fluid",
      "definition" : "Subgaleal Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SHIN",
      "display" : "Shin",
      "definition" : "Shin",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SHOL",
      "display" : "Shoulder",
      "definition" : "Shoulder",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SHOLJ",
      "display" : "Sholder Joint",
      "definition" : "Sholder Joint",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SIGMO",
      "display" : "Sigmoid",
      "definition" : "Sigmoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SINUS",
      "display" : "Sinus",
      "definition" : "Sinus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SKENE",
      "display" : "Skene's Gland",
      "definition" : "Skene's Gland",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SKM",
      "display" : "Skeletal Muscle",
      "definition" : "Skeletal Muscle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SKULL",
      "display" : "Skull",
      "definition" : "Skull",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SOLE",
      "display" : "Sole",
      "definition" : "Sole",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SPCOR",
      "display" : "Spinal Cord",
      "definition" : "Spinal Cord",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SPHEN",
      "display" : "Sphenoid",
      "definition" : "Sphenoid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SPLN",
      "display" : "Spleen",
      "definition" : "Spleen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SPRM",
      "display" : "Spermatozoa",
      "definition" : "Spermatozoa",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SPX",
      "display" : "Supra Cervical",
      "definition" : "Supra Cervical",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "STER",
      "display" : "Sternum/Sternal",
      "definition" : "Sternum/Sternal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "STOM",
      "display" : "Stoma",
      "definition" : "Stoma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "STOMA",
      "display" : "Stomach",
      "definition" : "Stomach",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "STOOLL",
      "display" : "Liquid Stool",
      "definition" : "Liquid Stool",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "STUMP",
      "display" : "Stump",
      "definition" : "Stump",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUB",
      "display" : "Subdural",
      "definition" : "Subdural",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUBD",
      "display" : "Subdural Fluid",
      "definition" : "Subdural Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUBM",
      "display" : "Submandibular",
      "definition" : "Submandibular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUBME",
      "display" : "Submental",
      "definition" : "Submental",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUBPH",
      "display" : "Subphrenic",
      "definition" : "Subphrenic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUBX",
      "display" : "Submaxillary",
      "definition" : "Submaxillary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUPB",
      "display" : "Suprapubic Specimen",
      "definition" : "Suprapubic Specimen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SUPRA",
      "display" : "Suprapubic",
      "definition" : "Suprapubic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SWT",
      "display" : "Sweat",
      "definition" : "Sweat",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SWTG",
      "display" : "Sweat Gland",
      "definition" : "Sweat Gland",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SYN",
      "display" : "Synovial Fluid",
      "definition" : "Synovial Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SYNOL",
      "display" : "Synovial",
      "definition" : "Synovial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SYNOV",
      "display" : "Synovium",
      "definition" : "Synovium",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TARS",
      "display" : "Tarsal",
      "definition" : "Tarsal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TBRON",
      "display" : "Transbronchial",
      "definition" : "Transbronchial",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TCN",
      "display" : "Transcarina Asp",
      "definition" : "Transcarina Asp",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TDUCT",
      "display" : "Tear Duct",
      "definition" : "Tear Duct",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TEAR",
      "display" : "Tears",
      "definition" : "Tears",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TEMPL",
      "display" : "Temple",
      "definition" : "Temple",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TEMPO",
      "display" : "Temporal",
      "definition" : "Temporal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TESTI",
      "display" : "Testicle(Testis)",
      "definition" : "Testicle(Testis)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "THIGH",
      "display" : "Thigh",
      "definition" : "Thigh",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "THM",
      "display" : "Thymus",
      "definition" : "Thymus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "THORA",
      "display" : "Thoracentesis",
      "definition" : "Thoracentesis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "THRB",
      "display" : "Throat",
      "definition" : "Throat",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "THUMB",
      "display" : "Thumb",
      "definition" : "Thumb",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "THYRD",
      "display" : "Thyroid",
      "definition" : "Thyroid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TIBIA",
      "display" : "Tibia",
      "definition" : "Tibia",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TML",
      "display" : "Temporal Lobe",
      "definition" : "Temporal Lobe",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TNL",
      "display" : "Thumbnail",
      "definition" : "Thumbnail",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TOE",
      "display" : "Toe",
      "definition" : "Toe",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TOEN",
      "display" : "Toe Nail",
      "definition" : "Toe Nail",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TONG",
      "display" : "Tongue",
      "definition" : "Tongue",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TONS",
      "display" : "Tonsil",
      "definition" : "Tonsil",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TOOTH",
      "display" : "Tooth",
      "definition" : "Tooth",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TRCHE",
      "display" : "Trachea/Tracheal",
      "definition" : "Trachea/Tracheal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TSK",
      "display" : "Tooth Socket",
      "definition" : "Tooth Socket",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ULNA",
      "display" : "Ulna/Ulnar",
      "definition" : "Ulna/Ulnar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UMB",
      "display" : "Umbilical Blood",
      "definition" : "Umbilical Blood",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UMBL",
      "display" : "Umbilicus",
      "definition" : "Umbilicus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "URET",
      "display" : "Ureter",
      "definition" : "Ureter",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "URTH",
      "display" : "Urethra",
      "definition" : "Urethra",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "USTOM",
      "display" : "Stoma, Urinary",
      "definition" : "Stoma, Urinary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UTER",
      "display" : "Uterus",
      "definition" : "Uterus",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UTERI",
      "display" : "Uterine",
      "definition" : "Uterine",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VAGIN",
      "display" : "Vagina/Vaginal",
      "definition" : "Vagina/Vaginal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VAL",
      "display" : "Valve",
      "definition" : "Valve",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VAS",
      "display" : "Vas Deferens",
      "definition" : "Vas Deferens",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VASTL",
      "display" : "Vastus Lateralis",
      "definition" : "Vastus Lateralis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VAULT",
      "display" : "Vault",
      "definition" : "Vault",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VCSF",
      "display" : "Ventricular CSF",
      "definition" : "Ventricular CSF",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VCUFF",
      "display" : "Vaginal Cuff",
      "definition" : "Vaginal Cuff",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VEIN",
      "display" : "Vein",
      "definition" : "Vein",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VENTG",
      "display" : "Ventragluteal",
      "definition" : "Ventragluteal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VERMI",
      "display" : "Vermis Cerebelli",
      "definition" : "Vermis Cerebelli",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VERTC",
      "display" : "Vertebra, cervical",
      "definition" : "Vertebra, cervical",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VERTL",
      "display" : "Vertebra, lumbar",
      "definition" : "Vertebra, lumbar",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VERTT",
      "display" : "Vertebra, thoracic",
      "definition" : "Vertebra, thoracic",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VESCL",
      "display" : "Vesicular",
      "definition" : "Vesicular",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VESFLD",
      "display" : "Vesicular Fluid",
      "definition" : "Vesicular Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VESI",
      "display" : "Vesicle",
      "definition" : "Vesicle",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VESTI",
      "display" : "Vestibule(Genital)",
      "definition" : "Vestibule(Genital)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VGV",
      "display" : "Vaginal Vault",
      "definition" : "Vaginal Vault",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VITR",
      "display" : "Vitreous Fluid",
      "definition" : "Vitreous Fluid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VOC",
      "display" : "Vocal Cord",
      "definition" : "Vocal Cord",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VULVA",
      "display" : "Vulva",
      "definition" : "Vulva",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WBC",
      "display" : "Leukocytes",
      "definition" : "Leukocytes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WRIST",
      "display" : "Wrist",
      "definition" : "Wrist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
