# Name Assembly Order (2.6 - 1.0.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Name Assembly Order (2.6 - 1.0.0)**

## CodeSystem: Name Assembly Order (2.6 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/nameAssemblyOrder | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:NameAssemblyOrder |
| *Other Identifiers:*OID:2.16.840.1.113883.18.284 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the preferred display order of the components of this person name. Used in HL7 Version 2.x messaging in the PPN, XCN and XPN segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSnameAssemblyOrder](ValueSet-hl7VSnameAssemblyOrder.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nameAssemblyOrder",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0444"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/nameAssemblyOrder",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.284"
    }
  ],
  "version" : "1.0.0",
  "name" : "NameAssemblyOrder",
  "title" : "Name Assembly Order (2.6 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the preferred display order of the components of this person name.  Used in HL7 Version 2.x messaging in the PPN, XCN and XPN segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "F",
      "display" : "Prefix Family Middle Given Suffix",
      "definition" : "Prefix Family Middle Given Suffix",
      "designation" : [
        {
          "language" : "de",
          "value" : "Familienname zuerst"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "G",
      "display" : "Prefix Given Middle Family Suffix",
      "definition" : "Prefix Given Middle Family Suffix",
      "designation" : [
        {
          "language" : "de",
          "value" : "Familienname hinten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
