# Message Error Condition Codes (2.6 - 1.0.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Message Error Condition Codes (2.6 - 1.0.0)**

## CodeSystem: Message Error Condition Codes (2.6 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/messageErrorCondition | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:MessageErrorCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.217 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ERR segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmessageErrorConditionCodes](ValueSet-hl7VSmessageErrorConditionCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "messageErrorCondition",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0357"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/messageErrorCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.217"
    }
  ],
  "version" : "1.0.0",
  "name" : "MessageErrorCondition",
  "title" : "Message Error Condition Codes (2.6 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the HL7 (communications) error code.  Used in the ERR segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "0",
      "display" : "Message accepted",
      "definition" : "Message accepted",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nachricht akzeptiert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "100",
      "display" : "Segment sequence error",
      "definition" : "Segment sequence error",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fehler in der Segmentreihenfolge"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "101",
      "display" : "Required field missing",
      "definition" : "Required field missing",
      "designation" : [
        {
          "language" : "de",
          "value" : "erforderliches Feld leer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "102",
      "display" : "Data type error",
      "definition" : "Data type error",
      "designation" : [
        {
          "language" : "de",
          "value" : "Datentypfehler"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "103",
      "display" : "Table value not found",
      "definition" : "Table value not found",
      "designation" : [
        {
          "language" : "de",
          "value" : "fehlender Eintrag in der Tabelle"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "200",
      "display" : "Unsupported message type",
      "definition" : "Unsupported message type",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nachrichtentyp wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "201",
      "display" : "Unsupported event code",
      "definition" : "Unsupported event code",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ereignis wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "202",
      "display" : "Unsupported processing id",
      "definition" : "Unsupported processing id",
      "designation" : [
        {
          "language" : "de",
          "value" : "Processing-ID wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "203",
      "display" : "Unsupported version id",
      "definition" : "Unsupported version id",
      "designation" : [
        {
          "language" : "de",
          "value" : "Version wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "204",
      "display" : "Unknown key identifier",
      "definition" : "Unknown key identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schlüsselwert nicht gefunden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "205",
      "display" : "Duplicate key identifier",
      "definition" : "Duplicate key identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "doppelter Schlüsselwert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "206",
      "display" : "Application record locked",
      "definition" : "Application record locked",
      "designation" : [
        {
          "language" : "de",
          "value" : "Datensatz durch Applikation gesperrt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "207",
      "display" : "Application internal error",
      "definition" : "Application internal error",
      "designation" : [
        {
          "language" : "de",
          "value" : "applikationsinterner Fehler"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
