# Invoice Control Code (2.6 - 1.0.0) - HL7 v2.6 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Invoice Control Code (2.6 - 1.0.0)**

## CodeSystem: Invoice Control Code (2.6 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/invoiceControl | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:InvoiceControl |
| *Other Identifiers:*OID:2.16.840.1.113883.18.357 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify what action is being performed by this message. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSinvoiceControlCode](ValueSet-hl7VSinvoiceControlCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "invoiceControl",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.6"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0553"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/invoiceControl",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.357"
    }
  ],
  "version" : "1.0.0",
  "name" : "InvoiceControl",
  "title" : "Invoice Control Code (2.6 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:31:23+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify what action is being performed by this message.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AA",
      "display" : "Authorization request for inpatient admission",
      "definition" : "Authorization request for inpatient admission",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "AI",
      "display" : "Combined Authorization and Adjudication request",
      "definition" : "Combined Authorization and Adjudication request",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Cancel Authorization request",
      "definition" : "Cancel Authorization request",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CG",
      "display" : "Cancel Invoice Product/Service Group",
      "definition" : "Cancel Invoice Product/Service Group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CL",
      "display" : "Cancel Invoice Product/Service Line Item",
      "definition" : "Cancel Invoice Product/Service Line Item",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CN",
      "display" : "Cancel Invoice",
      "definition" : "Cancel Invoice",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Copy of Invoice",
      "definition" : "Copy of Invoice",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CQ",
      "display" : "Coverage Register Query",
      "definition" : "Coverage Register Query",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EA",
      "display" : "Authorization request for inpatient stay extension",
      "definition" : "Authorization request for inpatient stay extension",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "OA",
      "display" : "Original Authorization",
      "definition" : "Original Authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "OR",
      "display" : "Original Invoice",
      "definition" : "Original Invoice",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Pre-Authorization",
      "definition" : "Pre-Authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PD",
      "display" : "Pre-Determination Invoice",
      "definition" : "Pre-Determination Invoice",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RA",
      "display" : "Re-Assessment",
      "definition" : "Re-Assessment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RC",
      "display" : "Referral Pre-Authorization",
      "definition" : "Referral Pre-Authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RU",
      "display" : "Referral authorization",
      "definition" : "Referral authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "SA",
      "display" : "Special Authorization",
      "definition" : "Special Authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
