# Specimen Source Codes (2.5.1 - 1.3.1) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Source Codes (2.5.1 - 1.3.1)**

## ValueSet: Specimen Source Codes (2.5.1 - 1.3.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSsourceOfSpecimen | *Version*:1.3.1 |
| Active as of 2026-01-27 | *Computable Name*:Hl7VSsourceOfSpecimen |
| *Other Identifiers:*OID:2.16.840.1.113883.21.31 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Value Set of codes which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "hl7VSsourceOfSpecimen",
  "url" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSsourceOfSpecimen",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.21.31"
    }
  ],
  "version" : "1.3.1",
  "name" : "Hl7VSsourceOfSpecimen",
  "title" : "Specimen Source Codes (2.5.1 - 1.3.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Value Set of codes which specify sources for speciments for clinical testing.  These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table",
  "copyright" : "HL7 Inc., 2026",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenSourceCodes",
        "version" : "0"
      }
    ]
  }
}

```
