# Abnormal Flags (2.5.1 - 1.3.1) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Abnormal Flags (2.5.1 - 1.3.1)**

## ValueSet: Abnormal Flags (2.5.1 - 1.3.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSinterpretationCode | *Version*:1.3.1 |
| Active as of 2026-01-27 | *Computable Name*:Hl7VSinterpretationCode |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.78 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "hl7VSinterpretationCode",
  "url" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSinterpretationCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.78"
    }
  ],
  "version" : "1.3.1",
  "name" : "Hl7VSinterpretationCode",
  "title" : "Abnormal Flags (2.5.1 - 1.3.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed.   Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts  (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version.",
  "copyright" : "HL7 Inc., 2026",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/observationInterpretation",
        "version" : "0"
      }
    ]
  }
}

```
