# Preferred Method of Contact (2.5.1 - 1.1.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Preferred Method of Contact (2.5.1 - 1.1.0)**

## CodeSystem: Preferred Method of Contact (2.5.1 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/preferredMethodOfContact | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:PreferredMethodOfContact |
| *Other Identifiers:*OID:2.16.840.1.113883.18.98 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person. Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpreferredMethodOfContrct](ValueSet-hl7VSpreferredMethodOfContrct.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "preferredMethodOfContact",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0185"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/preferredMethodOfContact",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.98"
    }
  ],
  "version" : "1.1.0",
  "name" : "PreferredMethodOfContact",
  "title" : "Preferred Method of Contact (2.5.1 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person.  Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Beeper Number",
      "definition" : "Beeper Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Beeper"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Cellular Phone Number",
      "definition" : "Cellular Phone Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Handy"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "E-Mail Address",
      "definition" : "E-Mail Address (for backward compatibility)",
      "designation" : [
        {
          "language" : "de",
          "value" : "E-Mail-Adresse"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "for backward compatibility"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "FAX Number",
      "definition" : "FAX Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fax"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "Home Phone Number",
      "definition" : "Home Phone Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "private Telefonnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Office Phone Number",
      "definition" : "Office Phone Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Dienstliche Telefonnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
