# Message Type (2.5.1 - 1.5.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Message Type (2.5.1 - 1.5.0)**

## CodeSystem: Message Type (2.5.1 - 1.5.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/messageType | *Version*:1.5.0 |
| Active as of 2026-01-27 | *Computable Name*:MessageType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.30 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmessageType](ValueSet-hl7VSmessageType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "messageType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0076"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/messageType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.30"
    }
  ],
  "version" : "1.5.0",
  "name" : "MessageType",
  "title" : "Message Type (2.5.1 - 1.5.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify message types.  Used in HL7 Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "chapter",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#chapter",
      "description" : "chapter",
      "type" : "string"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSevent"
        }
      ],
      "code" : "event",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#event",
      "description" : "event",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ACK",
      "display" : "General acknowledgment message",
      "definition" : "General acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "A01"
        },
        {
          "code" : "event",
          "valueCode" : "A02"
        },
        {
          "code" : "event",
          "valueCode" : "A03"
        },
        {
          "code" : "event",
          "valueCode" : "A04"
        },
        {
          "code" : "event",
          "valueCode" : "A05"
        },
        {
          "code" : "event",
          "valueCode" : "A06"
        },
        {
          "code" : "event",
          "valueCode" : "A07"
        },
        {
          "code" : "event",
          "valueCode" : "A08"
        },
        {
          "code" : "event",
          "valueCode" : "A09"
        },
        {
          "code" : "event",
          "valueCode" : "A10"
        },
        {
          "code" : "event",
          "valueCode" : "A11"
        },
        {
          "code" : "event",
          "valueCode" : "A12"
        },
        {
          "code" : "event",
          "valueCode" : "A13"
        },
        {
          "code" : "event",
          "valueCode" : "A14"
        },
        {
          "code" : "event",
          "valueCode" : "A15"
        },
        {
          "code" : "event",
          "valueCode" : "A16"
        },
        {
          "code" : "event",
          "valueCode" : "A17"
        },
        {
          "code" : "event",
          "valueCode" : "A18"
        },
        {
          "code" : "event",
          "valueCode" : "A20"
        },
        {
          "code" : "event",
          "valueCode" : "A21"
        },
        {
          "code" : "event",
          "valueCode" : "A22"
        },
        {
          "code" : "event",
          "valueCode" : "A23"
        },
        {
          "code" : "event",
          "valueCode" : "A24"
        },
        {
          "code" : "event",
          "valueCode" : "A25"
        },
        {
          "code" : "event",
          "valueCode" : "A26"
        },
        {
          "code" : "event",
          "valueCode" : "A27"
        },
        {
          "code" : "event",
          "valueCode" : "A28"
        },
        {
          "code" : "event",
          "valueCode" : "A29"
        },
        {
          "code" : "event",
          "valueCode" : "A30"
        },
        {
          "code" : "event",
          "valueCode" : "A31"
        },
        {
          "code" : "event",
          "valueCode" : "A32"
        },
        {
          "code" : "event",
          "valueCode" : "A33"
        },
        {
          "code" : "event",
          "valueCode" : "A34"
        },
        {
          "code" : "event",
          "valueCode" : "A35"
        },
        {
          "code" : "event",
          "valueCode" : "A36"
        },
        {
          "code" : "event",
          "valueCode" : "A37"
        },
        {
          "code" : "event",
          "valueCode" : "A38"
        },
        {
          "code" : "event",
          "valueCode" : "A39"
        },
        {
          "code" : "event",
          "valueCode" : "A40"
        },
        {
          "code" : "event",
          "valueCode" : "A41"
        },
        {
          "code" : "event",
          "valueCode" : "A42"
        },
        {
          "code" : "event",
          "valueCode" : "A43"
        },
        {
          "code" : "event",
          "valueCode" : "A44"
        },
        {
          "code" : "event",
          "valueCode" : "A45"
        },
        {
          "code" : "event",
          "valueCode" : "A46"
        },
        {
          "code" : "event",
          "valueCode" : "A47"
        },
        {
          "code" : "event",
          "valueCode" : "A48"
        },
        {
          "code" : "event",
          "valueCode" : "A49"
        },
        {
          "code" : "event",
          "valueCode" : "A50"
        },
        {
          "code" : "event",
          "valueCode" : "A51"
        },
        {
          "code" : "event",
          "valueCode" : "A52"
        },
        {
          "code" : "event",
          "valueCode" : "A53"
        },
        {
          "code" : "event",
          "valueCode" : "A54"
        },
        {
          "code" : "event",
          "valueCode" : "A55"
        },
        {
          "code" : "event",
          "valueCode" : "A60"
        },
        {
          "code" : "event",
          "valueCode" : "A61"
        },
        {
          "code" : "event",
          "valueCode" : "A62"
        },
        {
          "code" : "event",
          "valueCode" : "B01"
        },
        {
          "code" : "event",
          "valueCode" : "B02"
        },
        {
          "code" : "event",
          "valueCode" : "B03"
        },
        {
          "code" : "event",
          "valueCode" : "B04"
        },
        {
          "code" : "event",
          "valueCode" : "B05"
        },
        {
          "code" : "event",
          "valueCode" : "B06"
        },
        {
          "code" : "event",
          "valueCode" : "B07"
        },
        {
          "code" : "event",
          "valueCode" : "B08"
        },
        {
          "code" : "event",
          "valueCode" : "I07"
        },
        {
          "code" : "event",
          "valueCode" : "J01"
        },
        {
          "code" : "event",
          "valueCode" : "J02"
        },
        {
          "code" : "event",
          "valueCode" : "N02"
        },
        {
          "code" : "event",
          "valueCode" : "P01"
        },
        {
          "code" : "event",
          "valueCode" : "P02"
        },
        {
          "code" : "event",
          "valueCode" : "P03"
        },
        {
          "code" : "event",
          "valueCode" : "P05"
        },
        {
          "code" : "event",
          "valueCode" : "P06"
        },
        {
          "code" : "event",
          "valueCode" : "P10"
        },
        {
          "code" : "event",
          "valueCode" : "P11"
        },
        {
          "code" : "event",
          "valueCode" : "P12"
        },
        {
          "code" : "event",
          "valueCode" : "PC1"
        },
        {
          "code" : "event",
          "valueCode" : "PC2"
        },
        {
          "code" : "event",
          "valueCode" : "PC3"
        },
        {
          "code" : "event",
          "valueCode" : "PC6"
        },
        {
          "code" : "event",
          "valueCode" : "PC7"
        },
        {
          "code" : "event",
          "valueCode" : "PC8"
        },
        {
          "code" : "event",
          "valueCode" : "PCB"
        },
        {
          "code" : "event",
          "valueCode" : "PCC"
        },
        {
          "code" : "event",
          "valueCode" : "PCD"
        },
        {
          "code" : "event",
          "valueCode" : "PCG"
        },
        {
          "code" : "event",
          "valueCode" : "PCH"
        },
        {
          "code" : "event",
          "valueCode" : "PCJ"
        },
        {
          "code" : "event",
          "valueCode" : "Q03"
        },
        {
          "code" : "event",
          "valueCode" : "Q05"
        },
        {
          "code" : "event",
          "valueCode" : "Q16"
        },
        {
          "code" : "event",
          "valueCode" : "Q17"
        },
        {
          "code" : "event",
          "valueCode" : "R01"
        },
        {
          "code" : "event",
          "valueCode" : "R30"
        },
        {
          "code" : "event",
          "valueCode" : "R31"
        },
        {
          "code" : "event",
          "valueCode" : "R32"
        },
        {
          "code" : "event",
          "valueCode" : "S12"
        },
        {
          "code" : "event",
          "valueCode" : "S13"
        },
        {
          "code" : "event",
          "valueCode" : "S14"
        },
        {
          "code" : "event",
          "valueCode" : "S15"
        },
        {
          "code" : "event",
          "valueCode" : "S16"
        },
        {
          "code" : "event",
          "valueCode" : "S17"
        },
        {
          "code" : "event",
          "valueCode" : "S18"
        },
        {
          "code" : "event",
          "valueCode" : "S19"
        },
        {
          "code" : "event",
          "valueCode" : "S20"
        },
        {
          "code" : "event",
          "valueCode" : "S21"
        },
        {
          "code" : "event",
          "valueCode" : "S22"
        },
        {
          "code" : "event",
          "valueCode" : "S23"
        },
        {
          "code" : "event",
          "valueCode" : "S24"
        },
        {
          "code" : "event",
          "valueCode" : "S26"
        },
        {
          "code" : "event",
          "valueCode" : "T01"
        },
        {
          "code" : "event",
          "valueCode" : "T02"
        },
        {
          "code" : "event",
          "valueCode" : "T03"
        },
        {
          "code" : "event",
          "valueCode" : "T04"
        },
        {
          "code" : "event",
          "valueCode" : "T05"
        },
        {
          "code" : "event",
          "valueCode" : "T06"
        },
        {
          "code" : "event",
          "valueCode" : "T07"
        },
        {
          "code" : "event",
          "valueCode" : "T08"
        },
        {
          "code" : "event",
          "valueCode" : "T09"
        },
        {
          "code" : "event",
          "valueCode" : "T10"
        },
        {
          "code" : "event",
          "valueCode" : "T11"
        },
        {
          "code" : "event",
          "valueCode" : "U01"
        },
        {
          "code" : "event",
          "valueCode" : "U02"
        },
        {
          "code" : "event",
          "valueCode" : "U03"
        },
        {
          "code" : "event",
          "valueCode" : "U04"
        },
        {
          "code" : "event",
          "valueCode" : "U05"
        },
        {
          "code" : "event",
          "valueCode" : "U06"
        },
        {
          "code" : "event",
          "valueCode" : "U07"
        },
        {
          "code" : "event",
          "valueCode" : "U08"
        },
        {
          "code" : "event",
          "valueCode" : "U09"
        },
        {
          "code" : "event",
          "valueCode" : "U10"
        },
        {
          "code" : "event",
          "valueCode" : "U11"
        },
        {
          "code" : "event",
          "valueCode" : "U12"
        },
        {
          "code" : "event",
          "valueCode" : "U13"
        }
      ]
    },
    {
      "code" : "ADR",
      "display" : "ADT response",
      "definition" : "ADT response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Aufnahme / Verlegung / Entlassung von Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "A19"
        }
      ]
    },
    {
      "code" : "ADT",
      "display" : "ADT message",
      "definition" : "ADT message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aufnahme / Entlassung / Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "A01"
        },
        {
          "code" : "event",
          "valueCode" : "A02"
        },
        {
          "code" : "event",
          "valueCode" : "A03"
        },
        {
          "code" : "event",
          "valueCode" : "A04"
        },
        {
          "code" : "event",
          "valueCode" : "A05"
        },
        {
          "code" : "event",
          "valueCode" : "A06"
        },
        {
          "code" : "event",
          "valueCode" : "A07"
        },
        {
          "code" : "event",
          "valueCode" : "A08"
        },
        {
          "code" : "event",
          "valueCode" : "A09"
        },
        {
          "code" : "event",
          "valueCode" : "A10"
        },
        {
          "code" : "event",
          "valueCode" : "A11"
        },
        {
          "code" : "event",
          "valueCode" : "A12"
        },
        {
          "code" : "event",
          "valueCode" : "A13"
        },
        {
          "code" : "event",
          "valueCode" : "A14"
        },
        {
          "code" : "event",
          "valueCode" : "A15"
        },
        {
          "code" : "event",
          "valueCode" : "A16"
        },
        {
          "code" : "event",
          "valueCode" : "A17"
        },
        {
          "code" : "event",
          "valueCode" : "A18"
        },
        {
          "code" : "event",
          "valueCode" : "A20"
        },
        {
          "code" : "event",
          "valueCode" : "A21"
        },
        {
          "code" : "event",
          "valueCode" : "A22"
        },
        {
          "code" : "event",
          "valueCode" : "A23"
        },
        {
          "code" : "event",
          "valueCode" : "A24"
        },
        {
          "code" : "event",
          "valueCode" : "A25"
        },
        {
          "code" : "event",
          "valueCode" : "A26"
        },
        {
          "code" : "event",
          "valueCode" : "A27"
        },
        {
          "code" : "event",
          "valueCode" : "A28"
        },
        {
          "code" : "event",
          "valueCode" : "A29"
        },
        {
          "code" : "event",
          "valueCode" : "A30"
        },
        {
          "code" : "event",
          "valueCode" : "A31"
        },
        {
          "code" : "event",
          "valueCode" : "A32"
        },
        {
          "code" : "event",
          "valueCode" : "A33"
        },
        {
          "code" : "event",
          "valueCode" : "A34"
        },
        {
          "code" : "event",
          "valueCode" : "A35"
        },
        {
          "code" : "event",
          "valueCode" : "A36"
        },
        {
          "code" : "event",
          "valueCode" : "A37"
        },
        {
          "code" : "event",
          "valueCode" : "A38"
        },
        {
          "code" : "event",
          "valueCode" : "A39"
        },
        {
          "code" : "event",
          "valueCode" : "A40"
        },
        {
          "code" : "event",
          "valueCode" : "A41"
        },
        {
          "code" : "event",
          "valueCode" : "A42"
        },
        {
          "code" : "event",
          "valueCode" : "A43"
        },
        {
          "code" : "event",
          "valueCode" : "A44"
        },
        {
          "code" : "event",
          "valueCode" : "A45"
        },
        {
          "code" : "event",
          "valueCode" : "A46"
        },
        {
          "code" : "event",
          "valueCode" : "A47"
        },
        {
          "code" : "event",
          "valueCode" : "A48"
        },
        {
          "code" : "event",
          "valueCode" : "A49"
        },
        {
          "code" : "event",
          "valueCode" : "A50"
        },
        {
          "code" : "event",
          "valueCode" : "A51"
        },
        {
          "code" : "event",
          "valueCode" : "A52"
        },
        {
          "code" : "event",
          "valueCode" : "A53"
        },
        {
          "code" : "event",
          "valueCode" : "A54"
        },
        {
          "code" : "event",
          "valueCode" : "A55"
        },
        {
          "code" : "event",
          "valueCode" : "A60"
        },
        {
          "code" : "event",
          "valueCode" : "A61"
        },
        {
          "code" : "event",
          "valueCode" : "A62"
        }
      ]
    },
    {
      "code" : "BAR",
      "display" : "Add/change billing account",
      "definition" : "Add/change billing account",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hinzufügen / Ändern von Abrechnungsdaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "P01"
        },
        {
          "code" : "event",
          "valueCode" : "P02"
        },
        {
          "code" : "event",
          "valueCode" : "P05"
        },
        {
          "code" : "event",
          "valueCode" : "P06"
        },
        {
          "code" : "event",
          "valueCode" : "P10"
        },
        {
          "code" : "event",
          "valueCode" : "P12"
        }
      ]
    },
    {
      "code" : "BPS",
      "display" : "Blood product dispense status message",
      "definition" : "Blood product dispense status message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O29"
        }
      ]
    },
    {
      "code" : "BRP",
      "display" : "Blood product dispense status acknowledgement message",
      "definition" : "Blood product dispense status acknowledgement message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O30"
        }
      ]
    },
    {
      "code" : "BRT",
      "display" : "Blood product transfusion/disposition acknowledgement message",
      "definition" : "Blood product transfusion/disposition acknowledgement message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O32"
        }
      ]
    },
    {
      "code" : "BTS",
      "display" : "Blood product transfusion/disposition message",
      "definition" : "Blood product transfusion/disposition message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O31"
        }
      ]
    },
    {
      "code" : "CNQ",
      "display" : "Cancel query",
      "definition" : "Cancel query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung der Anfrage"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CRM",
      "display" : "Clinical study registration message",
      "definition" : "Clinical study registration message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "C01"
        },
        {
          "code" : "event",
          "valueCode" : "C02"
        },
        {
          "code" : "event",
          "valueCode" : "C03"
        },
        {
          "code" : "event",
          "valueCode" : "C04"
        },
        {
          "code" : "event",
          "valueCode" : "C05"
        },
        {
          "code" : "event",
          "valueCode" : "C06"
        },
        {
          "code" : "event",
          "valueCode" : "C07"
        },
        {
          "code" : "event",
          "valueCode" : "C08"
        }
      ]
    },
    {
      "code" : "CSU",
      "display" : "Unsolicited study data message",
      "definition" : "Unsolicited study data message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "C09"
        },
        {
          "code" : "event",
          "valueCode" : "C10"
        },
        {
          "code" : "event",
          "valueCode" : "C11"
        },
        {
          "code" : "event",
          "valueCode" : "C12"
        }
      ]
    },
    {
      "code" : "DFT",
      "display" : "Detail financial transactions",
      "definition" : "Detail financial transactions",
      "designation" : [
        {
          "language" : "de",
          "value" : "Einzelbuchung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "P03"
        },
        {
          "code" : "event",
          "valueCode" : "P11"
        }
      ]
    },
    {
      "code" : "DOC",
      "display" : "Document response",
      "definition" : "Document response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "T12"
        }
      ]
    },
    {
      "code" : "DSR",
      "display" : "Display response",
      "definition" : "Display response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort im Anzeigeformat"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q01"
        },
        {
          "code" : "event",
          "valueCode" : "Q03"
        }
      ]
    },
    {
      "code" : "EAC",
      "display" : "Automated equipment command message",
      "definition" : "Automated equipment command message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U07"
        }
      ]
    },
    {
      "code" : "EAN",
      "display" : "Automated equipment notification message",
      "definition" : "Automated equipment notification message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U09"
        }
      ]
    },
    {
      "code" : "EAR",
      "display" : "Automated equipment response message",
      "definition" : "Automated equipment response message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U08"
        }
      ]
    },
    {
      "code" : "EDR",
      "display" : "Enhanced display response",
      "definition" : "Enhanced display response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "R07"
        }
      ]
    },
    {
      "code" : "EQQ",
      "display" : "Embedded query language query",
      "definition" : "Embedded query language query",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "Q04"
        }
      ]
    },
    {
      "code" : "ERP",
      "display" : "Event replay response",
      "definition" : "Event replay response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "R09"
        }
      ]
    },
    {
      "code" : "ERQ",
      "display" : "Event replay query",
      "definition" : "Event replay query",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ESR",
      "display" : "Automated equipment status update acknowledgment message",
      "definition" : "Automated equipment status update acknowledgment message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U02"
        }
      ]
    },
    {
      "code" : "ESU",
      "display" : "Automated equipment status update message",
      "definition" : "Automated equipment status update message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U01"
        }
      ]
    },
    {
      "code" : "INR",
      "display" : "Automated equipment inventory request message",
      "definition" : "Automated equipment inventory request message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U06"
        }
      ]
    },
    {
      "code" : "INU",
      "display" : "Automated equipment inventory update message",
      "definition" : "Automated equipment inventory update message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U05"
        }
      ]
    },
    {
      "code" : "LSR",
      "display" : "Automated equipment log/service request message",
      "definition" : "Automated equipment log/service request message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U13"
        }
      ]
    },
    {
      "code" : "LSU",
      "display" : "Automated equipment log/service update message",
      "definition" : "Automated equipment log/service update message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U12"
        }
      ]
    },
    {
      "code" : "MCF",
      "display" : "Delayed Acknowledgment (Retained for backward compatibility only)",
      "definition" : "Delayed Acknowledgment (Retained for backward compatibility only)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "MDM",
      "display" : "Medical document management",
      "definition" : "Medical document management",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "T01"
        },
        {
          "code" : "event",
          "valueCode" : "T02"
        },
        {
          "code" : "event",
          "valueCode" : "T03"
        },
        {
          "code" : "event",
          "valueCode" : "T04"
        },
        {
          "code" : "event",
          "valueCode" : "T05"
        },
        {
          "code" : "event",
          "valueCode" : "T06"
        },
        {
          "code" : "event",
          "valueCode" : "T07"
        },
        {
          "code" : "event",
          "valueCode" : "T08"
        },
        {
          "code" : "event",
          "valueCode" : "T09"
        },
        {
          "code" : "event",
          "valueCode" : "T10"
        },
        {
          "code" : "event",
          "valueCode" : "T11"
        }
      ]
    },
    {
      "code" : "MFD",
      "display" : "Master files delayed application acknowledgment",
      "definition" : "Master files delayed application acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "MFK",
      "display" : "Master files application acknowledgment",
      "definition" : "Master files application acknowledgment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "M01"
        },
        {
          "code" : "event",
          "valueCode" : "M02"
        },
        {
          "code" : "event",
          "valueCode" : "M03"
        },
        {
          "code" : "event",
          "valueCode" : "M04"
        },
        {
          "code" : "event",
          "valueCode" : "M05"
        },
        {
          "code" : "event",
          "valueCode" : "M06"
        },
        {
          "code" : "event",
          "valueCode" : "M07"
        },
        {
          "code" : "event",
          "valueCode" : "M08"
        },
        {
          "code" : "event",
          "valueCode" : "M09"
        },
        {
          "code" : "event",
          "valueCode" : "M10"
        },
        {
          "code" : "event",
          "valueCode" : "M11"
        },
        {
          "code" : "event",
          "valueCode" : "M12"
        },
        {
          "code" : "event",
          "valueCode" : "M13"
        },
        {
          "code" : "event",
          "valueCode" : "M14"
        },
        {
          "code" : "event",
          "valueCode" : "M15"
        }
      ]
    },
    {
      "code" : "MFN",
      "display" : "Master files notification",
      "definition" : "Master files notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdateiänderung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "M01"
        },
        {
          "code" : "event",
          "valueCode" : "M02"
        },
        {
          "code" : "event",
          "valueCode" : "M03"
        },
        {
          "code" : "event",
          "valueCode" : "M04"
        },
        {
          "code" : "event",
          "valueCode" : "M05"
        },
        {
          "code" : "event",
          "valueCode" : "M06"
        },
        {
          "code" : "event",
          "valueCode" : "M07"
        },
        {
          "code" : "event",
          "valueCode" : "M08"
        },
        {
          "code" : "event",
          "valueCode" : "M09"
        },
        {
          "code" : "event",
          "valueCode" : "M10"
        },
        {
          "code" : "event",
          "valueCode" : "M11"
        },
        {
          "code" : "event",
          "valueCode" : "M12"
        },
        {
          "code" : "event",
          "valueCode" : "M13"
        },
        {
          "code" : "event",
          "valueCode" : "M14"
        },
        {
          "code" : "event",
          "valueCode" : "M15"
        }
      ]
    },
    {
      "code" : "MFQ",
      "display" : "Master files query",
      "definition" : "Master files query",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "M01"
        },
        {
          "code" : "event",
          "valueCode" : "M02"
        },
        {
          "code" : "event",
          "valueCode" : "M03"
        },
        {
          "code" : "event",
          "valueCode" : "M04"
        },
        {
          "code" : "event",
          "valueCode" : "M05"
        },
        {
          "code" : "event",
          "valueCode" : "M06"
        },
        {
          "code" : "event",
          "valueCode" : "M07"
        },
        {
          "code" : "event",
          "valueCode" : "M08"
        },
        {
          "code" : "event",
          "valueCode" : "M09"
        },
        {
          "code" : "event",
          "valueCode" : "M10"
        },
        {
          "code" : "event",
          "valueCode" : "M11"
        },
        {
          "code" : "event",
          "valueCode" : "M12"
        },
        {
          "code" : "event",
          "valueCode" : "M13"
        },
        {
          "code" : "event",
          "valueCode" : "M14"
        }
      ]
    },
    {
      "code" : "MFR",
      "display" : "Master files response",
      "definition" : "Master files response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Stammdateianfrage"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "M01"
        },
        {
          "code" : "event",
          "valueCode" : "M02"
        },
        {
          "code" : "event",
          "valueCode" : "M03"
        },
        {
          "code" : "event",
          "valueCode" : "M04"
        },
        {
          "code" : "event",
          "valueCode" : "M05"
        },
        {
          "code" : "event",
          "valueCode" : "M06"
        },
        {
          "code" : "event",
          "valueCode" : "M07"
        },
        {
          "code" : "event",
          "valueCode" : "M08"
        },
        {
          "code" : "event",
          "valueCode" : "M09"
        },
        {
          "code" : "event",
          "valueCode" : "M10"
        },
        {
          "code" : "event",
          "valueCode" : "M11"
        },
        {
          "code" : "event",
          "valueCode" : "M12"
        },
        {
          "code" : "event",
          "valueCode" : "M13"
        },
        {
          "code" : "event",
          "valueCode" : "M14"
        }
      ]
    },
    {
      "code" : "NMD",
      "display" : "Application management data message",
      "definition" : "Application management data message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "N02"
        }
      ]
    },
    {
      "code" : "NMQ",
      "display" : "Application management query message",
      "definition" : "Application management query message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "N01"
        }
      ]
    },
    {
      "code" : "NMR",
      "display" : "Application management response message",
      "definition" : "Application management response message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "N01"
        }
      ]
    },
    {
      "code" : "OMB",
      "display" : "Blood product order message",
      "definition" : "Blood product order message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O27"
        }
      ]
    },
    {
      "code" : "OMD",
      "display" : "Dietary order",
      "definition" : "Dietary order",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O03"
        }
      ]
    },
    {
      "code" : "OMG",
      "display" : "General clinical order message",
      "definition" : "General clinical order message",
      "designation" : [
        {
          "language" : "de",
          "value" : "allgemeiner Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O19"
        }
      ]
    },
    {
      "code" : "OMI",
      "display" : "Imaging order",
      "definition" : "Imaging order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag für bildgebende Untersuchung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O23"
        }
      ]
    },
    {
      "code" : "OML",
      "display" : "Laboratory order message",
      "definition" : "Laboratory order message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Laborauftrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O21"
        },
        {
          "code" : "event",
          "valueCode" : "O33"
        },
        {
          "code" : "event",
          "valueCode" : "O35"
        }
      ]
    },
    {
      "code" : "OMN",
      "display" : "Non-stock requisition order message",
      "definition" : "Non-stock requisition order message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O07"
        }
      ]
    },
    {
      "code" : "OMP",
      "display" : "Pharmacy/treatment order message",
      "definition" : "Pharmacy/treatment order message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O09"
        }
      ]
    },
    {
      "code" : "OMS",
      "display" : "Stock requisition order message",
      "definition" : "Stock requisition order message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O05"
        }
      ]
    },
    {
      "code" : "ORB",
      "display" : "Blood product order acknowledgement message",
      "definition" : "Blood product order acknowledgement message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O28"
        }
      ]
    },
    {
      "code" : "ORD",
      "display" : "Dietary order acknowledgment message",
      "definition" : "Dietary order acknowledgment message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O04"
        }
      ]
    },
    {
      "code" : "ORF",
      "display" : "Query for results of observation",
      "definition" : "Query for results of observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach Untersuchungsergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "R04"
        }
      ]
    },
    {
      "code" : "ORG",
      "display" : "General clinical order acknowledgment message",
      "definition" : "General clinical order acknowledgment message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O20"
        }
      ]
    },
    {
      "code" : "ORI",
      "display" : "Imaging order acknowledgement message",
      "definition" : "Imaging order acknowledgement message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "event",
          "valueCode" : "O24"
        }
      ]
    },
    {
      "code" : "ORL",
      "display" : "Laboratory acknowledgment message (unsolicited)",
      "definition" : "Laboratory acknowledgment message (unsolicited)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O22"
        },
        {
          "code" : "event",
          "valueCode" : "O34"
        },
        {
          "code" : "event",
          "valueCode" : "O36"
        }
      ]
    },
    {
      "code" : "ORM",
      "display" : "Pharmacy/treatment order message",
      "definition" : "Pharmacy/treatment order message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        }
      ]
    },
    {
      "code" : "ORN",
      "display" : "Non-stock requisition - General order acknowledgment message",
      "definition" : "Non-stock requisition - General order acknowledgment message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O08"
        }
      ]
    },
    {
      "code" : "ORP",
      "display" : "Pharmacy/treatment order acknowledgment message",
      "definition" : "Pharmacy/treatment order acknowledgment message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O10"
        }
      ]
    },
    {
      "code" : "ORR",
      "display" : "General order response message response to any ORM",
      "definition" : "General order response message response to any ORM",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung von der Anwendung für einen Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        }
      ]
    },
    {
      "code" : "ORS",
      "display" : "Stock requisition - Order acknowledgment message",
      "definition" : "Stock requisition - Order acknowledgment message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "O06"
        }
      ]
    },
    {
      "code" : "ORU",
      "display" : "Unsolicited transmission of an observation message",
      "definition" : "Unsolicited transmission of an observation message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht angeforderte Untersuchungsergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "R01"
        },
        {
          "code" : "event",
          "valueCode" : "R30"
        },
        {
          "code" : "event",
          "valueCode" : "R31"
        },
        {
          "code" : "event",
          "valueCode" : "R32"
        }
      ]
    },
    {
      "code" : "OSQ",
      "display" : "Query response for order status",
      "definition" : "Query response for order status",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q06"
        }
      ]
    },
    {
      "code" : "OSR",
      "display" : "Query response for order status",
      "definition" : "Query response for order status",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "Q06"
        }
      ]
    },
    {
      "code" : "OUL",
      "display" : "Unsolicited laboratory observation message",
      "definition" : "Unsolicited laboratory observation message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "R21"
        },
        {
          "code" : "event",
          "valueCode" : "R22"
        },
        {
          "code" : "event",
          "valueCode" : "R23"
        },
        {
          "code" : "event",
          "valueCode" : "R24"
        }
      ]
    },
    {
      "code" : "PEX",
      "display" : "Product experience message",
      "definition" : "Product experience message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "P07"
        },
        {
          "code" : "event",
          "valueCode" : "P08"
        }
      ]
    },
    {
      "code" : "PGL",
      "display" : "Patient goal message",
      "definition" : "Patient goal message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PC6"
        },
        {
          "code" : "event",
          "valueCode" : "PC7"
        },
        {
          "code" : "event",
          "valueCode" : "PC8"
        }
      ]
    },
    {
      "code" : "PIN",
      "display" : "Patient insurance information",
      "definition" : "Patient insurance information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I07"
        }
      ]
    },
    {
      "code" : "PMU",
      "display" : "Add personnel record",
      "definition" : "Add personnel record",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "B01"
        },
        {
          "code" : "event",
          "valueCode" : "B02"
        },
        {
          "code" : "event",
          "valueCode" : "B03"
        },
        {
          "code" : "event",
          "valueCode" : "B04"
        },
        {
          "code" : "event",
          "valueCode" : "B05"
        },
        {
          "code" : "event",
          "valueCode" : "B06"
        },
        {
          "code" : "event",
          "valueCode" : "B07"
        },
        {
          "code" : "event",
          "valueCode" : "B08"
        }
      ]
    },
    {
      "code" : "PPG",
      "display" : "Patient pathway message (goal-oriented)",
      "definition" : "Patient pathway message (goal-oriented)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PCG"
        },
        {
          "code" : "event",
          "valueCode" : "PCH"
        },
        {
          "code" : "event",
          "valueCode" : "PCJ"
        }
      ]
    },
    {
      "code" : "PPP",
      "display" : "Patient pathway message (problem-oriented)",
      "definition" : "Patient pathway message (problem-oriented)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PCB"
        },
        {
          "code" : "event",
          "valueCode" : "PCC"
        },
        {
          "code" : "event",
          "valueCode" : "PCD"
        }
      ]
    },
    {
      "code" : "PPR",
      "display" : "Patient problem message",
      "definition" : "Patient problem message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PC1"
        },
        {
          "code" : "event",
          "valueCode" : "PC2"
        },
        {
          "code" : "event",
          "valueCode" : "PC3"
        }
      ]
    },
    {
      "code" : "PPT",
      "display" : "Patient pathway goal-oriented response",
      "definition" : "Patient pathway goal-oriented response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PCL"
        }
      ]
    },
    {
      "code" : "PPV",
      "display" : "Patient goal response",
      "definition" : "Patient goal response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PCA"
        }
      ]
    },
    {
      "code" : "PRR",
      "display" : "Patient problem response",
      "definition" : "Patient problem response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PC5"
        }
      ]
    },
    {
      "code" : "PTR",
      "display" : "Patient pathway problem-oriented response",
      "definition" : "Patient pathway problem-oriented response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "PCF"
        }
      ]
    },
    {
      "code" : "QBP",
      "display" : "Query by parameter",
      "definition" : "Query by parameter",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "Q11"
        },
        {
          "code" : "event",
          "valueCode" : "Q13"
        },
        {
          "code" : "event",
          "valueCode" : "Q15"
        },
        {
          "code" : "event",
          "valueCode" : "Q21"
        },
        {
          "code" : "event",
          "valueCode" : "Q22"
        },
        {
          "code" : "event",
          "valueCode" : "Q23"
        },
        {
          "code" : "event",
          "valueCode" : "Q24"
        },
        {
          "code" : "event",
          "valueCode" : "Q25"
        },
        {
          "code" : "event",
          "valueCode" : "Q31"
        },
        {
          "code" : "event",
          "valueCode" : "Z73"
        },
        {
          "code" : "event",
          "valueCode" : "Z75"
        },
        {
          "code" : "event",
          "valueCode" : "Z77"
        },
        {
          "code" : "event",
          "valueCode" : "Z79"
        },
        {
          "code" : "event",
          "valueCode" : "Z81"
        },
        {
          "code" : "event",
          "valueCode" : "Z85"
        },
        {
          "code" : "event",
          "valueCode" : "Z87"
        },
        {
          "code" : "event",
          "valueCode" : "Z89"
        },
        {
          "code" : "event",
          "valueCode" : "Z91"
        },
        {
          "code" : "event",
          "valueCode" : "Z93"
        },
        {
          "code" : "event",
          "valueCode" : "Z95"
        },
        {
          "code" : "event",
          "valueCode" : "Z97"
        },
        {
          "code" : "event",
          "valueCode" : "Z99"
        }
      ]
    },
    {
      "code" : "QCK",
      "display" : "Query general acknowledgment",
      "definition" : "Deferred query",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "Q02"
        }
      ]
    },
    {
      "code" : "QCN",
      "display" : "Cancel query",
      "definition" : "Cancel query",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "J01"
        }
      ]
    },
    {
      "code" : "QRY",
      "display" : "Query, original mode",
      "definition" : "Query, original mode",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "A19"
        },
        {
          "code" : "event",
          "valueCode" : "PC4"
        },
        {
          "code" : "event",
          "valueCode" : "PC9"
        },
        {
          "code" : "event",
          "valueCode" : "PCE"
        },
        {
          "code" : "event",
          "valueCode" : "PCK"
        },
        {
          "code" : "event",
          "valueCode" : "Q01"
        },
        {
          "code" : "event",
          "valueCode" : "Q02"
        },
        {
          "code" : "event",
          "valueCode" : "Q26"
        },
        {
          "code" : "event",
          "valueCode" : "Q27"
        },
        {
          "code" : "event",
          "valueCode" : "Q28"
        },
        {
          "code" : "event",
          "valueCode" : "Q29"
        },
        {
          "code" : "event",
          "valueCode" : "Q30"
        },
        {
          "code" : "event",
          "valueCode" : "R02"
        },
        {
          "code" : "event",
          "valueCode" : "T12"
        }
      ]
    },
    {
      "code" : "QSB",
      "display" : "Create subscription",
      "definition" : "Create subscription",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "Q16"
        },
        {
          "code" : "event",
          "valueCode" : "Z83"
        }
      ]
    },
    {
      "code" : "QSX",
      "display" : "Cancel subscription/acknowledge message",
      "definition" : "Cancel subscription/acknowledge message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "J02"
        }
      ]
    },
    {
      "code" : "QVR",
      "display" : "Query for previous events",
      "definition" : "Query for previous events",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "Q17"
        }
      ]
    },
    {
      "code" : "RAR",
      "display" : "Pharmacy/treatment administration information",
      "definition" : "Pharmacy/treatment administration information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "RAR"
        }
      ]
    },
    {
      "code" : "RAS",
      "display" : "Pharmacy/treatment administration message",
      "definition" : "Pharmacy/treatment administration message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Erfolgte Verabreichung von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O17"
        }
      ]
    },
    {
      "code" : "RCI",
      "display" : "Return clinical information",
      "definition" : "Return clinical information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I05"
        }
      ]
    },
    {
      "code" : "RCL",
      "display" : "Return clinical list",
      "definition" : "Return clinical list",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I06"
        }
      ]
    },
    {
      "code" : "RDE",
      "display" : "Pharmacy/treatment encoded order message",
      "definition" : "Pharmacy/treatment encoded order message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Medikamentenverordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O11"
        },
        {
          "code" : "event",
          "valueCode" : "O25"
        }
      ]
    },
    {
      "code" : "RDR",
      "display" : "Pharmacy/treatment dispense information",
      "definition" : "Pharmacy/treatment dispense information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Abgabe von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "RDR"
        }
      ]
    },
    {
      "code" : "RDS",
      "display" : "Pharmacy/treatment dispense message",
      "definition" : "Pharmacy/treatment dispense message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgabe von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O13"
        }
      ]
    },
    {
      "code" : "RDY",
      "display" : "Display based response",
      "definition" : "Display based response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "K15"
        },
        {
          "code" : "event",
          "valueCode" : "Z80"
        },
        {
          "code" : "event",
          "valueCode" : "Z98"
        }
      ]
    },
    {
      "code" : "REF",
      "display" : "Patient referral",
      "definition" : "Patient referral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Überweisung eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I12"
        },
        {
          "code" : "event",
          "valueCode" : "I13"
        },
        {
          "code" : "event",
          "valueCode" : "I14"
        },
        {
          "code" : "event",
          "valueCode" : "I15"
        }
      ]
    },
    {
      "code" : "RER",
      "display" : "Pharmacy/treatment encoded order information",
      "definition" : "Pharmacy/treatment encoded order information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Medikamentenverordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "RER"
        }
      ]
    },
    {
      "code" : "RGR",
      "display" : "Pharmacy/treatment dose information",
      "definition" : "Pharmacy/treatment dose information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Verabreichungsvorschrift für Medikamente"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "RGR"
        }
      ]
    },
    {
      "code" : "RGV",
      "display" : "Pharmacy/treatment give message",
      "definition" : "Pharmacy/treatment give message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verabreichungsvorschrift für Medikamente"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O15"
        }
      ]
    },
    {
      "code" : "ROC",
      "display" : "Request clinical information",
      "definition" : "Request clinical information",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ROD",
      "display" : "Request pateint demographics",
      "definition" : "Request pateint demographics",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ROR",
      "display" : "Pharmacy/treatment order response",
      "definition" : "Pharmacy/treatment order response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Medikamentenverordnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "ROR"
        }
      ]
    },
    {
      "code" : "RPA",
      "display" : "Return patient authorization",
      "definition" : "Return patient authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I08"
        },
        {
          "code" : "event",
          "valueCode" : "I09"
        },
        {
          "code" : "event",
          "valueCode" : "I10"
        },
        {
          "code" : "event",
          "valueCode" : "I11"
        }
      ]
    },
    {
      "code" : "RPI",
      "display" : "Return patient information",
      "definition" : "Return patient information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I01"
        },
        {
          "code" : "event",
          "valueCode" : "I04"
        }
      ]
    },
    {
      "code" : "RPL",
      "display" : "Return patient display list",
      "definition" : "Return patient display list",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I02"
        }
      ]
    },
    {
      "code" : "RPR",
      "display" : "Return patient list",
      "definition" : "Return patient list",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I03"
        }
      ]
    },
    {
      "code" : "RQA",
      "display" : "Request patient authorization",
      "definition" : "Request patient authorization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I08"
        },
        {
          "code" : "event",
          "valueCode" : "I09"
        },
        {
          "code" : "event",
          "valueCode" : "I10"
        },
        {
          "code" : "event",
          "valueCode" : "I11"
        }
      ]
    },
    {
      "code" : "RQC",
      "display" : "Request clinical information",
      "definition" : "Request clinical information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I05"
        },
        {
          "code" : "event",
          "valueCode" : "I06"
        }
      ]
    },
    {
      "code" : "RQI",
      "display" : "Request patient information",
      "definition" : "Request patient information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I01"
        },
        {
          "code" : "event",
          "valueCode" : "I02"
        },
        {
          "code" : "event",
          "valueCode" : "I03"
        }
      ]
    },
    {
      "code" : "RQP",
      "display" : "Request patient demographics",
      "definition" : "Request patient demographics",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I04"
        }
      ]
    },
    {
      "code" : "RQQ",
      "display" : "Event replay query",
      "definition" : "Event replay query",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q09"
        }
      ]
    },
    {
      "code" : "RRA",
      "display" : "Pharmacy/treatment administration acknowledgment message",
      "definition" : "Pharmacy/treatment administration acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Verabreichungsmeldung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O18"
        }
      ]
    },
    {
      "code" : "RRD",
      "display" : "Pharmacy/treatment dispense acknowledgment message",
      "definition" : "Pharmacy/treatment dispense acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Abgabemeldung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O14"
        }
      ]
    },
    {
      "code" : "RRE",
      "display" : "Pharmacy/treatment encoded order acknowledgment message",
      "definition" : "Pharmacy/treatment encoded order acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Verordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O12"
        },
        {
          "code" : "event",
          "valueCode" : "O26"
        }
      ]
    },
    {
      "code" : "RRG",
      "display" : "Pharmacy/treatment give acknowledgment message",
      "definition" : "Pharmacy/treatment give acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Verabreichungsvorschrift"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "event",
          "valueCode" : "O16"
        }
      ]
    },
    {
      "code" : "RRI",
      "display" : "Return referral information",
      "definition" : "Return referral information",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "I12"
        },
        {
          "code" : "event",
          "valueCode" : "I13"
        },
        {
          "code" : "event",
          "valueCode" : "I14"
        },
        {
          "code" : "event",
          "valueCode" : "I15"
        }
      ]
    },
    {
      "code" : "RSP",
      "display" : "Segment pattern response",
      "definition" : "Segment pattern response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "K11"
        },
        {
          "code" : "event",
          "valueCode" : "K21"
        },
        {
          "code" : "event",
          "valueCode" : "K22"
        },
        {
          "code" : "event",
          "valueCode" : "K23"
        },
        {
          "code" : "event",
          "valueCode" : "K24"
        },
        {
          "code" : "event",
          "valueCode" : "K25"
        },
        {
          "code" : "event",
          "valueCode" : "K31"
        },
        {
          "code" : "event",
          "valueCode" : "Z82"
        },
        {
          "code" : "event",
          "valueCode" : "Z84"
        },
        {
          "code" : "event",
          "valueCode" : "Z86"
        },
        {
          "code" : "event",
          "valueCode" : "Z88"
        },
        {
          "code" : "event",
          "valueCode" : "Z90"
        }
      ]
    },
    {
      "code" : "RTB",
      "display" : "Tabular response",
      "definition" : "Tabular response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "K13"
        },
        {
          "code" : "event",
          "valueCode" : "Z74"
        },
        {
          "code" : "event",
          "valueCode" : "Z76"
        },
        {
          "code" : "event",
          "valueCode" : "Z78"
        },
        {
          "code" : "event",
          "valueCode" : "Z92"
        },
        {
          "code" : "event",
          "valueCode" : "Z94"
        },
        {
          "code" : "event",
          "valueCode" : "Z96"
        }
      ]
    },
    {
      "code" : "SIU",
      "display" : "Schedule information unsolicited",
      "definition" : "Schedule information unsolicited",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "S12"
        },
        {
          "code" : "event",
          "valueCode" : "S13"
        },
        {
          "code" : "event",
          "valueCode" : "S14"
        },
        {
          "code" : "event",
          "valueCode" : "S15"
        },
        {
          "code" : "event",
          "valueCode" : "S16"
        },
        {
          "code" : "event",
          "valueCode" : "S17"
        },
        {
          "code" : "event",
          "valueCode" : "S18"
        },
        {
          "code" : "event",
          "valueCode" : "S19"
        },
        {
          "code" : "event",
          "valueCode" : "S20"
        },
        {
          "code" : "event",
          "valueCode" : "S21"
        },
        {
          "code" : "event",
          "valueCode" : "S22"
        },
        {
          "code" : "event",
          "valueCode" : "S23"
        },
        {
          "code" : "event",
          "valueCode" : "S24"
        },
        {
          "code" : "event",
          "valueCode" : "S26"
        }
      ]
    },
    {
      "code" : "SPQ",
      "display" : "Stored procedure request",
      "definition" : "Stored procedure request",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "Q08"
        }
      ]
    },
    {
      "code" : "SQM",
      "display" : "Schedule query message",
      "definition" : "Schedule query message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "S25"
        }
      ]
    },
    {
      "code" : "SQR",
      "display" : "Schedule query response",
      "definition" : "Schedule query response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "S25"
        }
      ]
    },
    {
      "code" : "SRM",
      "display" : "Schedule request message",
      "definition" : "Schedule request message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "S01"
        },
        {
          "code" : "event",
          "valueCode" : "S02"
        },
        {
          "code" : "event",
          "valueCode" : "S03"
        },
        {
          "code" : "event",
          "valueCode" : "S04"
        },
        {
          "code" : "event",
          "valueCode" : "S05"
        },
        {
          "code" : "event",
          "valueCode" : "S06"
        },
        {
          "code" : "event",
          "valueCode" : "S07"
        },
        {
          "code" : "event",
          "valueCode" : "S08"
        },
        {
          "code" : "event",
          "valueCode" : "S09"
        },
        {
          "code" : "event",
          "valueCode" : "S10"
        },
        {
          "code" : "event",
          "valueCode" : "S11"
        }
      ]
    },
    {
      "code" : "SRR",
      "display" : "Scheduled request response",
      "definition" : "Scheduled request response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "S01"
        },
        {
          "code" : "event",
          "valueCode" : "S02"
        },
        {
          "code" : "event",
          "valueCode" : "S03"
        },
        {
          "code" : "event",
          "valueCode" : "S04"
        },
        {
          "code" : "event",
          "valueCode" : "S05"
        },
        {
          "code" : "event",
          "valueCode" : "S06"
        },
        {
          "code" : "event",
          "valueCode" : "S07"
        },
        {
          "code" : "event",
          "valueCode" : "S08"
        },
        {
          "code" : "event",
          "valueCode" : "S09"
        },
        {
          "code" : "event",
          "valueCode" : "S10"
        },
        {
          "code" : "event",
          "valueCode" : "S11"
        }
      ]
    },
    {
      "code" : "SSR",
      "display" : "Specimen status request message",
      "definition" : "Specimen status request message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U04"
        }
      ]
    },
    {
      "code" : "SSU",
      "display" : "Specimen status update message",
      "definition" : "Specimen status update message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U03"
        }
      ]
    },
    {
      "code" : "SUR",
      "display" : "Summary product experience report",
      "definition" : "Summary product experience report",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P09"
        }
      ]
    },
    {
      "code" : "TBR",
      "display" : "Tabular data response",
      "definition" : "Tabular data response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "R08"
        }
      ]
    },
    {
      "code" : "TCR",
      "display" : "Automated equipment test code settings request message",
      "definition" : "Automated equipment test code settings request message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U11"
        }
      ]
    },
    {
      "code" : "TCU",
      "display" : "Automated equipment test code settings update message",
      "definition" : "Automated equipment test code settings update message",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "event",
          "valueCode" : "U10"
        }
      ]
    },
    {
      "code" : "UDM",
      "display" : "Unsolicited display update message",
      "definition" : "Unsolicited display update message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht angeforderte Nachricht im Anzeigeformat"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q05"
        }
      ]
    },
    {
      "code" : "VQQ",
      "display" : "Virtual table query",
      "definition" : "Virtual table query",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "Q07"
        }
      ]
    },
    {
      "code" : "VXQ",
      "display" : "Query for vaccination record",
      "definition" : "Query for vaccination record",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "V01"
        }
      ]
    },
    {
      "code" : "VXR",
      "display" : "Vaccination record response",
      "definition" : "Vaccination record response",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "V03"
        }
      ]
    },
    {
      "code" : "VXU",
      "display" : "Unsolicited vaccination record update",
      "definition" : "Unsolicited vaccination record update",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "V04"
        }
      ]
    },
    {
      "code" : "VXX",
      "display" : "Response for vaccination query with multiple PID matches",
      "definition" : "Response for vaccination query with multiple PID matches",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "event",
          "valueCode" : "V02"
        }
      ]
    }
  ]
}

```
