# Contact Role (2.5.1 - 1.0.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contact Role (2.5.1 - 1.0.0)**

## CodeSystem: Contact Role (2.5.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/contactRole2 | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ContactRole2 |
| *Other Identifiers:*OID:2.16.840.1.113883.18.58 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. Used in HL7 Version 2 messaging in the NK1 and CTD segments after 2.5, when it replace 2.16.840.1.113883.18.57. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScontactRole2](ValueSet-hl7VScontactRole2.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contactRole2",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0131"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/contactRole2",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.58"
    }
  ],
  "version" : "1.0.0",
  "name" : "ContactRole2",
  "title" : "Contact Role (2.5.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. Used in HL7 Version 2 messaging in the NK1 and CTD segments after 2.5, when it replace 2.16.840.1.113883.18.57.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Emergency Contact",
      "definition" : "Emergency Contact",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ansprechpartner in Notfällen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Employer",
      "definition" : "Employer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitgeber"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Federal Agency",
      "definition" : "Federal Agency",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bundesbehörde"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Insurance Company",
      "definition" : "Insurance Company",
      "designation" : [
        {
          "language" : "de",
          "value" : "Versicherung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Next-of-Kin",
      "definition" : "Next-of-Kin",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kontaktperson"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "andere"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "State Agency",
      "definition" : "State Agency",
      "designation" : [
        {
          "language" : "de",
          "value" : "Landesbehörde"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
